package com.biz.crm.worksign.mapper;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import java.util.List;

/**
 * 请假申请 
 * 
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
public interface SfaLeaveMapper extends BaseMapper<SfaLeaveEntity> {
    /**
     * 列表
     * @param page
     * @param sfaLeaveReqVo
     * @return
     */
    List<SfaLeaveRespVo> findList(Page<SfaLeaveRespVo> page, @Param("vo") SfaLeaveListReqVo sfaLeaveReqVo);

    /**
     * 查询日期冲突数据
     * 1、非拒绝状态
     * 2、原开始时间 <= 结束时间 and 原结束时间 >= 开始时间
     * @param userName 用户账号
     * @param beginTime 开始时间
     * @param endTime 结束时间
     * @param id 排除的id
     * @return
     */
    List<SfaLeaveRespVo> findRepeatByDates(@Param("userName") String userName, @Param("beginTime") String beginTime
            , @Param("endTime")String endTime,@Param("id") String id);

    /**
     * 请假申请明细
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "t.org_code",posCode = "t.pos_code")
    List<SfaLeaveApplyDetailRespVo> leaveApplyDetail(Page<SfaLeaveApplyDetailRespVo> page
            , @Param("vo") SfaLeaveApplyDetailReqVo reqVo);

    /**
     * 请假申请汇总
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_leave.org_code" , posCode = "sfa_leave.pos_code")
    List<SfaLeaveApplySummaryRespVo> leaveApplySummary(Page<SfaLeaveApplySummaryRespVo> page
            , @Param("vo") SfaLeaveApplySummaryReqVo reqVo);

    /**
     * 获取有效期内可以抵扣的请假整列表
     * @param leaveIndate
     * @return
     */
    List<SfaLeaveEntity> findNotUseDays(@Param("userName") String userName,@Param("leaveIndate") int leaveIndate);
}
