package com.biz.crm.worksign.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.worksign.form.req.*;
import com.biz.crm.nebular.sfa.worksign.form.resp.*;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName SfaSignFormsMapper.java
 * @Description 考勤报表数据接口
 * @createTime 2020年11月25日 17:21:00
 */
public interface SfaSignFormsMapper {

    /**
     * 获取打卡类型列表
     * @return
     */
    List<Map<String, String>> getWorkSignType();

    /**
     * 考勤明细
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "t.ws_org_code",posCode = "t.ws_pos_code")
    List<SfaSignDetailRespVo> signDetail(Page<SfaSignDetailRespVo> page
            ,@Param("vo") SfaSignDetailReqVo reqVo);


    /**
     * 月度考勤报表明细
     * @method getSignInfo
     * @date: 2021/4/2 17:23
     * @author: YuanZiJian
     * @param id
     * @param ruleType
     * @return com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo
     */
    SfaSignDetailRespVo getSignInfo(@Param("id")String id ,@Param("ruleType") String ruleType);

    /**
     * 月度考勤报表-人员信息
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_work_sign_rule_info.org_code",posCode = "sfa_work_sign_rule_info.pos_code")
    List<SfaMonthSignRespVo> monthSignUserInfoForPage(Page<SfaMonthSignRespVo> page
            ,@Param("vo") SfaMonthSignReqVo reqVo);

    List<SfaMonthSignRespVo> monthSignUserInfoForUser(@Param("vo") SfaMonthSignReqVo reqVo);
    /**
     * 月度考勤报表-考勤明细
     * @param yearMonth 年月信息
     * @param userNameList
     * @return
     */
    List<SfaMonthWorkSignRecordRespVo> monthSignDaysInfo(@Param("yearMonth") String yearMonth, @Param("clockType") String clockType, @Param("userNameList") List<String> userNameList);

    /**
     * 异常报备申请明细报表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "t.org_code",posCode = "t.pos_code")
    List<SfaExceptionReportDetailRespVo> exceptionReportDetail(Page<SfaExceptionReportDetailRespVo> page
            , @Param("vo") SfaExceptionReportDetailReqVo reqVo);

    /** sfaVisitStepStockInventoryFindStockInventoryReportList
     * 根据id集合查询对应记录详细
     * @param ids
     * @return
     */
    List<SfaWorkSignRecordRespVo> findRecordsById(@Param("ids") List<String> ids);

    /**
     * 根据审核任务ID查询
     * @param auditTaskId
     * @return
     */
    SfaExceptionReportDetailRespVo queryByAuditTaskId(@Param("auditTaskId") String auditTaskId);
}
