package com.biz.crm.worksign.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工作日调整
 * 
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
public interface SfaWorkOvertimeMapper extends BaseMapper<SfaWorkOvertimeEntity> {
    /**
     * 列表
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaWorkOvertimeRespVo> findList(Page<SfaWorkOvertimeRespVo> page, @Param("vo") SfaWorkOvertimeListReqVo reqVo);

    /**
     * 查询日期冲突数据
     * 1、非拒绝状态
     * 2、原开始时间 <= 结束时间 and 原结束时间 >= 开始时间
     * @param userName 用户账号
     * @param beginTime 开始时间
     * @param endTime 结束时间
     * @param id 排除的id
     * @return
     */
    List<SfaWorkOvertimeRespVo> findRepeatByDates(@Param("userName") String userName, @Param("beginTime") String beginTime
            , @Param("endTime")String endTime,@Param("id") String id);

    /**
     * 工作日调整申请明细
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_work_overtime.org_code",posCode = "sfa_work_overtime.pos_code")
    List<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(Page<SfaWorkOvertimeDetailRespVo> page
            , @Param("vo") SfaWorkOvertimeDetailReqVo reqVo);

    /**
     * 工作日调整申请汇总
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_work_overtime.org_code",posCode = "sfa_work_overtime.pos_code")
    List<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(Page<SfaWorkOvertimeSummaryRespVo> page
            , @Param("vo") SfaWorkOvertimeSummaryReqVo reqVo);

    /**
     * 获取有效期内可以抵扣的工作日调整列表
     * @param indate
     * @return
     */
    List<SfaWorkOvertimeEntity> findNotUseDays(@Param("userName") String userName, @Param("indate") int indate);

}
