package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 出差申请 实体类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_travel")
@CrmTable(name = "sfa_travel", tableNote = "出差申请")
public class SfaTravelEntity extends CrmExtTenEntity<SfaTravelEntity> {

    /**
     * 申请人员账号 申请人员账号
     */
    @CrmColumn(name = "apply_user_name", length = 100, note = "申请人员账号 申请人员账号")
    private String applyUserName;

    /**
     * 申请人员姓名 申请人员姓名
     */
    @CrmColumn(name = "apply_real_name", length = 100, note = "申请人员姓名 申请人员姓名")
    private String applyRealName;

    /**
     * 申请职位编码 申请职位编码
     */
    @CrmColumn(name = "apply_pos_code", length = 32, note = "申请职位编码 申请职位编码")
    private String applyPosCode;

    /**
     * 申请职位名称 申请职位名称
     */
    @CrmColumn(name = "apply_pos_name", length = 100, note = "申请职位名称 申请职位名称")
    private String applyPosName;

    /**
     * 申请所属组织编码 申请所属组织编码
     */
    @CrmColumn(name = "apply_org_code", length = 32, note = "申请所属组织编码 申请所属组织编码")
    private String applyOrgCode;

    /**
     * 申请所属组织名称 申请所属组织名称
     */
    @CrmColumn(name = "apply_org_name", length = 100, note = "申请所属组织名称 申请所属组织名称")
    private String applyOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "apply_parent_org_code", length = 64, note = "上级组织编码")
    private String applyParentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "apply_parent_org_name", length = 64, note = "上级组织名称")
    private String applyParentOrgName;

    /**
     * 申请日期 申请日期(yyyy-MM-dd HH:mm:dd)
     */
    @CrmColumn(name = "application_date", length = 32, note = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    /**
     * 开始时间 开始时间(yyyy-MM-dd)
     */
    @CrmColumn(name = "begin_time", length = 32, note = "开始时间 开始时间(yyyy-MM-dd)")
    private String beginTime;

    /**
     * 结束时间 结束时间(yyyy-MM-dd)
     */
    @CrmColumn(name = "end_time", length = 32, note = "结束时间 结束时间(yyyy-MM-dd)")
    private String endTime;

    /**
     * 出差地点 出差地点
     */
    @CrmColumn(name = "address", length = 200, note = "出差地点 出差地点")
    private String address;

    /**
     * 出差目的 出差目的
     */
    @CrmColumn(name = "travel_objective", length = 200, note = "出差目的 出差目的")
    private String travelObjective;

    /**
     * 审批状态 审批状态
     */
    @CrmColumn(name = "bpm_status", length = 512, note = "审批状态 审批状态")
    private String bpmStatus;

    /**
     * 审核任务id
     */
    @CrmColumn(name = "audit_task_id", length = 64, note = "审核任务id")
    private String auditTaskId;

    /**
     * 审核通过时间
     */
    @CrmColumn(name = "pass_status_date", length = 64, note = "审核通过时间")
    private String passStatusDate;

    /**
     * 销假天数
     */
    @CrmColumn(name = "process_no", length = 24, note = "流程编号")
    private String processNo;

}
