package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 出差人员表 实体类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_travel_user")
@CrmTable(name = "sfa_travel_user", tableNote = "出差人员表")
public class SfaTravelUserEntity extends CrmExtTenEntity<SfaTravelUserEntity> {

    /**
     * 出差申请id 出差申请id
     */
    @CrmColumn(name = "travel_id", length = 32, note = "出差申请id 出差申请id")
    private String travelId;

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "活动编码")
    private String userName;

    /**
     * 人员姓名 人员姓名
     */
    @CrmColumn(name = "real_name", length = 100, note = "人员姓名 人员姓名")
    private String realName;

    /**
     * 职位编码 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码 职位编码")
    private String posCode;

    /**
     * 职位名称 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称 职位名称")
    private String posName;

    /**
     * 所属组织编码 所属组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "所属组织编码 所属组织编码")
    private String orgCode;

    /**
     * 所属组织名称 所属组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "所属组织名称 所属组织名称")
    private String orgName;

}
