package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @author ren.gang
 * @ClassName SfaWorkOvertimeTimeInfoEntity.java
 * @Description 工作日调整明细
 * @createTime 2020年12月17日 15:37:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_overtime_time_info")
@CrmTable(name = "sfa_work_overtime_time_info", tableNote = "工作日调整明细",indexes = {
        @Index(name = "work_overtime_time_info_index1",columnList = "overtime_id"),
        @Index(name = "work_overtime_time_info_index2",columnList = "user_name")
})
public class SfaWorkOvertimeTimeInfoEntity extends CrmExtTenEntity<SfaWorkOvertimeTimeInfoEntity> {

    /**
     * 工作日调整id
     */
    @CrmColumn(name = "overtime_id", length = 32, note = "工作日调整id")
    private String overtimeId;
    /**
     * 人员帐号
     */
    @CrmColumn(name = "user_name", length = 32, note = "人员帐号")
    private String userName;
    /**
     * 人员职位
     */
    @CrmColumn(name = "pos_code", length = 32, note = "人员职位")
    private String posCode;
    /**
     * 所属组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "所属组织编码")
    private String orgCode;
    /**
     * 所属组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "所属组织名称")
    private String orgName;
    /**
     * 调整日期
     */
    @CrmColumn(name = "overtime_date", length = 32, note = "调整日期")
    private String overtimeDate;
    /**
     * 日期类型(1全天，2上午，3下午)
     */
    @CrmColumn(name = "time_type", length = 32, note = "日期类型(1全天，2上午，3下午)")
    private String timeType;
}
