package com.biz.crm.worksign.resp;

import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 其他时间段的打卡记录——用于打卡记录详情时产生的
 * @author YuanZiJian
 * @date 2021/4/21 15:29
 * @version: V1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "其他时间段的打卡记录")
public class SfaWorkSignOtherTimeRecordRespVo  {
    /**
     * 打卡记录Id
     */
    @ApiModelProperty("打卡记录Id")
    private String id;
    /**
     * 打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;
     */
    @ApiModelProperty("打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;")
    private String workSignType;

    /**
     * 打卡类型描述 打卡类型描述
     */
    @ApiModelProperty("打卡类型描述 打卡类型描述")
    private String workSignDesc;

    /**
     * 考勤时间规则-签到时间(HH:mm:ss)
     */
    @ApiModelProperty("考勤时间规则-签到时间(HH:mm:ss)")
    private String sfaSignTime;

    /**
     * 考勤打卡签到时间(HH:mm:ss)
     */
    @ApiModelProperty("考勤打卡签到时间(HH:mm:ss)")
    private String workSignTime;
}
