package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;

import java.util.List;

/**
 * 异常报备 业务接口
 *
 * @author ren.gang
 * @date 2020-11-23 15:00:38
 */
public interface ISfaExceptionReportService extends IService<SfaExceptionReportEntity> {

    /**
     *
     * 获取某个时间端中
     * 存在的补打卡类型
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    List<SfaAddSignTypeRespVo> getAddSignType (String startTime,String endTime);


    /**
     * 列表
     * @param reqVo
     * @return PageResult<SfaExceptionReportRespVo>
     */
    PageResult<SfaExceptionReportRespVo> findList(SfaExceptionReportListReqVo reqVo);

    /**
     * 查询单个明细
     * @param id
     * @return
     */
    SfaExceptionReportRespVo query(String id);

    /**
     * 根据审核任务ID查询
     * @param auditTaskId
     * @return
     */
    SfaExceptionReportRespVo queryByAuditTaskId(String auditTaskId);

    /**
     * 保存申请信息
     * @param reqVo
     * @return
     */
    Result apply(SfaExceptionReportReqVo reqVo);

    /**
     * 追回
     * @param id
     * @return
     */
    Result rollback(String id);


    /**
     * 提交审核信息
     */
    Result auditCommit(String id);

    /**
     * 根据任务流返回信息查询审核任务列表
     * @param result
     * @param reqVo
     * @return
     */
    PageResult<SfaAuditListExceptionRespVo> findAuditList(PageResult<TaskRspVO> result, SfaExceptionReportListReqVo reqVo);

    /**
     * 审核完成回调
     * @param reqVo
     */
    void auditFinish(SfaAuditFinishReqVo reqVo);
}

