package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName ISfaLeaveCancelService.java
 * @Description 销假业务接口
 * @createTime 2020年12月09日 22:15:00
 */
public interface ISfaLeaveCancelService extends IService<SfaLeaveCancelEntity> {

    /**
     * 列表
     * @param reqVo
     * @return PageResult<SfaLeaveRespVo>
     */
    List<SfaLeaveCancelRespVo> findList(SfaLeaveCancelReqVo reqVo);


    /**
     * 新增
     * @param reqVo
     * @return
     */
    SfaLeaveCancelEntity save(SfaLeaveCancelReqVo reqVo, boolean isAudit);


    /**
     * 校验申请时间冲突
     * @param list 销假列表
     * @param beginTime 开始时间
     * @param endTime 结束时间
     * @param timeInfoList 时间明细
     */
    void verifyDateRepeat(List<SfaLeaveCancelRespVo> list, String beginTime, String endTime, List<SfaApplyTimeInfoReqVo> timeInfoList);

    /**
     * 销假详情列表
     * @param reqVo
     * @return
     */
    PageResult<SfaLeaveCancelInfoRespVo> findInfoList(SfaAuditListLeaveCancelReqVo reqVo);

    /**
     * 提交审核信息
     * @param id
     * @return
     */
    Result auditCommit(String id);

    /**
     * 销假审批完成
     * @param reqVo
     */
    SfaLeaveCancelEntity auditCancelFinish(SfaAuditFinishReqVo reqVo);


    /**
     * 根据任务流返回信息查询审核任务列表
     * @param mobileResult
     * @param reqVo
     * @return
     */
    PageResult<SfaAuditListLeaveCancelRespVo> findAuditList(PageResult<TaskRspVO> mobileResult, SfaAuditListLeaveCancelReqVo reqVo);
}
