package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaLeaveEntity;

import java.util.List;

/**
 * 请假申请 接口
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
public interface ISfaLeaveService extends IService<SfaLeaveEntity> {

    /**
     * 列表
     * @param sfaLeaveReqVo
     * @return PageResult<SfaLeaveRespVo>
     */
    PageResult<SfaLeaveRespVo> findList(SfaLeaveListReqVo sfaLeaveReqVo);

    /**
     * 设置请假相关的销假信息
     */
    void setLeaveCancelInfo(SfaLeaveRespVo vo);

    /**
     * 查询
     * @param sfaLeaveReqVo
     * @return SfaLeaveRespVo
     */
    SfaLeaveRespVo query(SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 根据审核任务id查询
     * @param auditTaskId
     * @return SfaLeaveRespVo
     */
    SfaLeaveRespVo queryByAuditTaskId(String auditTaskId);

    /**
     * 新增
     * @param sfaLeaveReqVo
     * @return
     */
    void save(SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 更新
     * @param sfaLeaveReqVo
     * @return
     */
    void update(SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 删除
     * @param reqVo
     * @return
     */
    void deleteBatch(CrmIdsReqVo reqVo);

    /**
     * 启用
     * @param reqVo
     * @return
     */
    void enableBatch(CrmIdsReqVo reqVo);

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    void disableBatch(CrmIdsReqVo reqVo);

    /**
     * 请假申请接口
     * @param sfaLeaveReqVo
     * @return
     */
    Result goApplyLeave(SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 计算请假时长
     * @param reqVo
     * @return
     */
    SfaLeaveEntity countApplyDays(SfaLeaveReqVo reqVo);

    /**
     * 追回请假申请
     * @param id
     * @return
     */
    Result rollbackLeave(String id);

    /**
     * 追加附件信息
     * @param sfaLeaveReqVo
     * @return
     */
    Result addAttachment(SfaLeaveReqVo sfaLeaveReqVo);

    /**
     * 销假
     * @param reqVo
     * @return
     */
    Result cancelLeave(SfaAuditCancelReqVo reqVo);

    /**
     * 根据任务流返回信息查询审核任务列表
     * @param taskRspVOPageResult
     * @return
     */
    PageResult<SfaAuditListLeaveRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult
            , SfaLeaveListReqVo reqVo);

    /**
     * 提交审核信息
     */
    Result auditCommit(String id);

    /**
     * 审核完成回调
     * @param reqVo
     */
    void auditFinish(SfaAuditFinishReqVo reqVo);

    /**
     * 销假审核完成回调
     * @param reqVo
     */
    void auditCancelFinish(SfaAuditFinishReqVo reqVo);

    /**
     *
     * @return
     */
    int getLeaveIndate();

    /**
     * 获取有效期内可以抵扣的请假整列表
     * @return
     */
    List<SfaLeaveEntity> findNotUseDaysList(String userName);
}

