package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyAttachmentReqVo;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName ISfaLeaveAttachmentService.java
 * @Description 请假申请-附件
 * @createTime 2020年12月04日 23:07:00
 */
public interface ISfaSignApplyAttachmentService extends IService<SfaSignApplyAttachmentEntity> {


    /**
     * 根据类型和来源查询
     * @param applyType
     * @param sourceId
     * @return
     */
    SfaSignApplyAttachmentEntity getEntity(String applyType, String sourceId);


    /**
     * 保存考勤申请相关附件信息，先删除后保存
     * @param applyType 申请类型
     * @param sourceId 来源id
     * @param attachmentList 附件列表
     */
    void save(String applyType, String sourceId, List<SfaApplyAttachmentReqVo> attachmentList);
}
