package com.biz.crm.worksign.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.*;
import com.biz.crm.nebular.sfa.worksign.form.resp.*;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName ISfaSignFormsService.java
 * @Description 考勤报表业务接口
 * @createTime 2020年11月25日 17:13:00
 */
public interface ISfaSignFormsService {

    /**
     * 增加考勤信息
     * @method getSignAddRecordInfo
     * @date: 2021/2/25 14:26
     * @author: YuanZiJian
     * @param sfaSignAddRecordSearchReqVo 搜索条件Vo
     * @return com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignAddRecordInfoRespVo
     */
    SfaSignAddRecordInfoRespVo getSignAddRecordInfo (SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo);


    /**
     * 获取打卡类型列表
     * @return
     */
    List<Map<String, String>> getWorkSignType();

    /**
     * 考勤明细报表
     * @param reqVo
     * @return
     */
    SfaSignDetailRespVo getSignInfo(String id , String ruleType);


    /**
     * 考勤明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo);

    /**
     * 月度考勤报表
     * @param reqVo
     * @return
     */
    PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo);
    /**
     * 统计给定用户的月度考勤
     * @param reqVo
     * @return
     */
    List<SfaMonthSignRespVo> monthSignListByUsers(SfaMonthSignReqVo reqVo);

    /**
     * 请假申请明细
     * @param reqVo
     * @return
     */
    PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo);

    /**
     * 请假申请汇总
     * @param reqVo
     * @return
     */
    PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo);

    /**
     * 工作日调整申请明细
     * @param reqVo
     * @return
     */
    PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo);

    /**
     * 工作日调整申请汇总
     * @param reqVo
     * @return
     */
    PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo);

    /**
     * 异常报备申请明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo);

    /**
     * 出差申请明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaTravelRespVo> travelDetail(@RequestBody SfaTravelReqVo reqVo);

    /**
     * 获取用户当前主职位信息
     * @return
     */
    MdmPositionUserOrgRespVo getUserOrgInfo(String userName);

    /**
     * 根据审核人任务id查询工作日调整明细
     * @param auditTaskId
     * @return
     */
    SfaWorkOvertimeRespVo queryOvertiem(String auditTaskId);

    /**
     * 根据审核人任务id查询请假明细
     * @param auditTaskId
     * @return
     */
    SfaLeaveRespVo queryleave(String auditTaskId);

    /**
     * 根据审核人任务id查询异常报备明细
     * @param auditTaskId
     * @return
     */
    SfaExceptionReportDetailRespVo queryException(String auditTaskId);

    /**
     * 根据审核人任务id查询出差明细
     * @param auditTaskId
     * @return
     */
    SfaTravelRespVo queryTravel(String auditTaskId);

    /**
     * 根据审核任务id查询销假明细
     * @param auditTaskId
     * @return
     */
    SfaLeaveCancelInfoRespVo queryLeaveCancel(String auditTaskId);

    /**
     * 个人月度考勤报表 默认当前人员  当月
     * @param reqVo
     * @return
     */
    SfaMonthSignRespVo appUserByMonthSign(SfaMonthSignReqVo reqVo);
}
