package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelApplyReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaTravelEntity;

import java.util.List;

/**
 * 出差申请 接口
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
public interface ISfaTravelService extends IService<SfaTravelEntity> {

    /**
     * 列表
     * @param sfaTravelReqVo
     * @return PageResult<SfaTravelRespVo>
     */
    PageResult<SfaTravelRespVo> findList(SfaTravelReqVo sfaTravelReqVo);

    /**
     * 列表
     * @param sfaTravelReqVo
     * @return List<SfaTravelRespVo>
     */
    List<SfaTravelRespVo> findDataList(SfaTravelReqVo sfaTravelReqVo);

    /**
     * 查询
     * @param id
     * @return SfaTravelRespVo
     */
    SfaTravelRespVo query(String id);

    /**
     * 出差申请接口
     * @param reqVo
     * @return
     */
    Result goApplyTravel(SfaTravelApplyReqVo reqVo);

    /**
     * 根据任务流返回信息查询审核任务列表
     * @param result
     * @param reqVo
     * @return
     */
    PageResult<SfaAuditListTravelRespVo> findAuditList(PageResult<TaskRspVO> result, SfaTravelReqVo reqVo);

    /**
     * 追回
     * @param id
     * @return
     */
    Result rollback(String id);

    /**
     * 提交审核信息
     * @param id
     * @return
     */
    Result auditCommit(String id);

    /**
     * 审核完成回调
     * @param reqVo
     */
    void auditFinish(SfaAuditFinishReqVo reqVo);

    /**
     * 根据审核任务ID查询
     * @param auditTaskId
     * @return
     */
    SfaTravelRespVo queryByAuditTaskId(String auditTaskId);


//    /**
//     * 删除
//     * @param sfaTravelReqVo
//     * @return
//     */
//    void deleteBatch(SfaTravelReqVo sfaTravelReqVo);
//
//    /**
//     * 启用
//     * @param sfaTravelReqVo
//     * @return
//     */
//    void enableBatch(SfaTravelReqVo sfaTravelReqVo);
//
//    /**
//     * 禁用
//     * @param sfaTravelReqVo
//     * @return
//     */
//    void disableBatch(SfaTravelReqVo sfaTravelReqVo);

}

