package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.*;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;

import java.util.List;

/**
 * 工作日调整 业务接口
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
public interface ISfaWorkOvertimeService extends IService<SfaWorkOvertimeEntity> {

    /**
     * 列表
     * @param reqVo
     * @return PageResult<SfaWorkOvertimeRespVo>
     */
    PageResult<SfaWorkOvertimeRespVo> findList(SfaWorkOvertimeListReqVo reqVo);

    /**
     * 查询单个明细
     * @param id
     * @return
     */
    SfaWorkOvertimeRespVo query(String id);

    /**
     * 查询单个明细-根据审核任务id
     * @param auditTaskId
     * @return
     */
    SfaWorkOvertimeRespVo queryByAuditTaskId(String auditTaskId);

    /**
     * 保存申请信息
     * @param reqVo
     * @return
     */
    Result apply(SfaWorkOvertimeReqVo reqVo);

    /**
     * 当前考勤明细是否有工作日调整
     * @param workSignRuleInfoEntity
     * @return
     */
    boolean hasOvertime(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity);

    /**
     * 追回
     * @param id
     * @return
     */
    Result rollback(String id);


    /**
     * 提交审核信息
     */
    Result auditCommit(String id);

    /**
     * 根据任务流返回信息查询审核任务列表
     * @param result
     * @param reqVo
     * @return
     */
    PageResult<SfaAuditListOvertimeRespVo> findAuditList(PageResult<TaskRspVO> result, SfaWorkOvertimeListReqVo reqVo);

    /**
     * 审核完成回调
     * @param reqVo
     */
    void auditFinish(SfaAuditFinishReqVo reqVo);

    /**
     *
     * @return
     */
    int getOvertimeIndate();

    /**
     * 获取有效期内可以抵扣的工作日调整列表
     * 1、状态为审批通过,2、有效期内，3、剩余天数大于0
     * @return
     */
    List<SfaWorkOvertimeEntity> findNotUseDaysList(String userName);
}

