package com.biz.crm.worksign.service;

import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignPictureRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignPictureReqVo;

import java.util.List;
import java.util.Map;

/**
 * 考勤照片 接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
public interface ISfaWorkSignPictureService extends IService<SfaWorkSignPictureEntity> {

    /**
     * 列表
     * @param sfaWorkSignPictureReqVo
     * @return PageResult<SfaWorkSignPictureRespVo>
     */
    PageResult<SfaWorkSignPictureRespVo> findList(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    List<SfaWorkSignPictureRespVo> selectByRecordId(String wsRecordId);
    /**
     * 查询
     * @param sfaWorkSignPictureReqVo
     * @return SfaWorkSignPictureRespVo
     */
    SfaWorkSignPictureRespVo query(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 新增
     * @param sfaWorkSignPictureReqVo
     * @return
     */
    void save(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 更新
     * @param sfaWorkSignPictureReqVo
     * @return
     */
    void update(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 删除
     * @param sfaWorkSignPictureReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 启用
     * @param sfaWorkSignPictureReqVo
     * @return
     */
    void enableBatch(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 禁用
     * @param sfaWorkSignPictureReqVo
     * @return
     */
    void disableBatch(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);
}

