package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;

import java.util.List;

/**
 * 考勤规则明细表 接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
public interface ISfaWorkSignRuleInfoService extends IService<SfaWorkSignRuleInfoEntity> {

    /**
     * 列表
     * @param sfaWorkSignRuleInfoReqVo
     * @return PageResult<SfaWorkSignRuleInfoRespVo>
     */
    PageResult<SfaWorkSignRuleInfoRespVo> findList(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 查询
     * @param sfaWorkSignRuleInfoReqVo
     * @return SfaWorkSignRuleInfoRespVo
     */
    @Deprecated
    SfaWorkSignRuleInfoRespVo query(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 新增
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    void save(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 更新
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    void update(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 删除
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 启用
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    void enableBatch(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);

    /**
     * 禁用
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    void disableBatch(SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);



    /**
     * 查询考勤明细报表列表
     * @param sfaWorkSignInfoReqVo
     * @return PageResult<SfaWorkSignRuleInfoRespVo>
     */
    PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo);


    /*********************************************微信端接口查询********************************************************/
    /**
     * 查询考勤明细
     * @return
     */
    SfaWorkSignRuleInfoEntity loadRuleInfoForClock();

    /**
     * 获取当前时间考勤签到信息
     * @param signType 打卡类型
     * @return
     */
    SfaWorkSignRecordRespVo findSignRecordByNow(SfaWorkSignEnum.WorkSignType signType);

    /**
     * 获取工作台页面——所有的气泡和通知
     * @method getAllNotice
     * @date: 2021/3/15 11:04
     * @author: YuanZiJian
     * @return com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo
     */
    SfaNoticeRespVo getAllNoticeRedis();

//    /**
//     * 查询当前登录人 当前时间上班签到
//     * @return
//     */
//    SfaWorkSignRecordRespVo fingGotoWorkClockIn(String signType);


//    /**
//     * 查询当前登录人 当前时间下班签退
//     * @return
//     */
//    SfaWorkSignRecordRespVo fingGooffWorkSignOut();


    /**
     * 分片批量保存
     * @param infoEntityList
     */
    void saveBatchPartition(List<SfaWorkSignRuleInfoEntity> infoEntityList);

    /**
     * 根据用户名和打卡日期查询
     * @param userName
     * @param ruleDate
     * @return
     */
    SfaWorkSignRuleInfoEntity findByUserNameAndRuleDate(String userName, String ruleDate);
}

