package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.model.SfaCheckInSignRecordPictureEntity;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordPictureService;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordPictureRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.*;
import com.biz.crm.nebular.sfa.worksign.form.resp.*;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.*;
import com.biz.crm.util.*;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaSignFormsMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.*;
import com.biz.crm.worksign.service.*;
import com.biz.crm.worksign.service.component.MonthSignReportQueryContext;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.biz.crm.worksignrule.util.SignRuleUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author ren.gang
 * @ClassName ISfaSignFormsServiceImpl.java
 * @Description 考勤报表业务实现
 * @createTime 2020年11月25日 17:14:00
 */
@Service
public class SfaSignFormsServiceImpl implements ISfaSignFormsService {

    @Resource
    private SfaSignFormsMapper mapper;
    @Resource
    private ISfaWorkOvertimeService overtimeService;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Resource
    private ISfaLeaveService leaveService;
    @Resource
    private ISfaLeaveCancelService cancelService;
    @Resource
    private ISfaWorkOvertimeTimeInfoService sfaWorkOvertimeTimeInfoService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    @Resource
    private ISfaSignApplyAttachmentService sfaSignApplyAttachmentService;
    @Resource
    private ISfaTravelService travelService;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private ISfaLeaveCancelService leaveCancelService;
    @Resource
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    private ISfaWorkSignTimeService iSfaWorkSignTimeService;
    @Resource
    private ISfaWorkSummaryService sfaWorkSummaryService;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaCheckInSignRecordPictureService sfaCheckInSignRecordPictureService;
    @Resource
    private ISfaCheckInSignRecordService sfaCheckInSignRecordService;



    /**
     * 增加考勤信息
     *
     * @param sfaSignAddRecordSearchReqVo 搜索条件Vo
     * @return com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignAddRecordInfoRespVo
     * @method getSignAddRecordInfo
     * @date: 2021/2/25 14:26
     * @author: YuanZiJian
     */
    @Override
    public SfaSignAddRecordInfoRespVo getSignAddRecordInfo(SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo) {
        //校验判断
        if(StringUtils.isEmpty(sfaSignAddRecordSearchReqVo.getRuleDate())){
            throw new BusinessException("请选择考勤日期");
        }
        if(StringUtils.isEmpty(sfaSignAddRecordSearchReqVo.getPosCode())){
            throw new BusinessException("请选择考勤人员职位");
        }
        if(StringUtils.isEmpty(sfaSignAddRecordSearchReqVo.getOrgCode())){
            throw new BusinessException("请选择考勤人员组织");
        }
        //先根据账号、时间、职位、所属组织来确定到某个规则明细
        SfaWorkSignRuleInfoEntity infoEntity = sfaWorkSignRuleInfoService.getOne(Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class)
                .eq(SfaWorkSignRuleInfoEntity::getUserName, sfaSignAddRecordSearchReqVo.getUserName())
                .eq(SfaWorkSignRuleInfoEntity::getRuleDate, sfaSignAddRecordSearchReqVo.getRuleDate()));
        if(infoEntity != null){
            throw new BusinessException("已经存在考勤记录！");
        }
        MdmPositionRespVo primaryPosition = PositionUtil.getPositionByCode(sfaSignAddRecordSearchReqVo.getPosCode());
        SfaWorkSignRuleEntity ruleEntity = SignRuleUtils.getUserSignRuleCode(primaryPosition);
        if(null == ruleEntity){
            throw new BusinessException("未查询到该用户可用的考勤规则，请前往考勤规则配置页面完善配置数据！");
        }

        infoEntity = SignRuleUtils.buildSfaWorkSignRuleInfoEntity(ruleEntity, primaryPosition, sfaSignAddRecordSearchReqVo.getRuleDate());

        List<SfaWorkSignRecordEntity> recordEntities = SignRuleUtils.buildSfaWorkSignRecordEntity(infoEntity);

        //考勤明细转为打卡类型的下拉数据+手动封装workSignTypeName字段
        List<SfaAddSignTypeRespVo> signTypeRespVos = CrmBeanUtil.copyList(recordEntities, SfaAddSignTypeRespVo.class);
        signTypeRespVos.forEach(data->{
            data.setId(data.getSfaSignTimeId() + "@" + data.getWorkSignType());
            data.setWorkSignTypeName(SfaWorkSignEnum.WorkSignType.getDesc(data.getWorkSignType()));
            data.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        });
        //组装返回数据
        SfaSignAddRecordInfoRespVo infoRespVo = CrmBeanUtil.copy(infoEntity, SfaSignAddRecordInfoRespVo.class);
        infoRespVo.setRuleTypeName(SfaWorkSignEnum.WorkSignRuleType.getDesc(infoRespVo.getRuleType()));
        infoRespVo.setSfaAddSignTypeRespVoList(signTypeRespVos);
        return infoRespVo;
    }

    /**
     * 获取打卡类型列表
     * @return
     */
    @Override
    public List<Map<String, String>> getWorkSignType() {
        List<Map<String, String>> list = mapper.getWorkSignType();
        if(CollectionUtil.listEmpty(list)) {
            list = new ArrayList<>();
        }
        Map<String, String> clockInMap = new HashMap<>();
        clockInMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
        clockInMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getDesc());
        list.add(clockInMap);

        Map<String, String> clockOutMap = new HashMap<>();
        clockOutMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
        clockOutMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getDesc());
        list.add(clockOutMap);

        return list;
    }

    private SfaSignDetailRespVo setValue(SfaCheckInSignRecordRespVo query) {
        SfaSignDetailRespVo signInfo = CrmBeanUtil.copy(query, SfaSignDetailRespVo.class);
        signInfo.setWsUserName(query.getUserName());
        signInfo.setWsRealName(query.getRealName());
        signInfo.setWsPosCode(query.getPosCode());
        signInfo.setWsPosName(query.getPosName());
        signInfo.setWsOrgCode(query.getOrgCode());
        signInfo.setWsOrgName(query.getOrgName());
        signInfo.setRuleDate(query.getSignDate());
        signInfo.setWorkSignTime(query.getSignTime());
        signInfo.setWorkSignPlace(query.getSignPlace());
        return signInfo;
    }

    /**
     * 考勤明细报表
     *
     * @param id
     * @param ruleType
     * @return
     */
    @Override
    public SfaSignDetailRespVo getSignInfo(String id, String ruleType) {
        AssertUtils.isNotEmpty(id,"入参id不能为空");
        AssertUtils.isNotEmpty(ruleType,"入参ruleType不能为空");
        SfaSignDetailRespVo signInfo = mapper.getSignInfo(id, ruleType);
        if(null == signInfo){
            //自由签到未在签到组
            SfaCheckInSignRecordRespVo query = sfaCheckInSignRecordService.query(id);
            if (null == query){
                throw  new BusinessException("未查询到详情");
            }
            signInfo = this.setValue(query);
        }
        //设置基础字段
        signInfo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc(signInfo.getWorkSignStatus()));
        signInfo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc(signInfo.getRuleType()));
        if(StringUtils.isNotEmpty(signInfo.getWorkSignTime())) {
            signInfo.setWorkSignTime(signInfo.getRuleDate() + " " + signInfo.getWorkSignTime());
        } else {
            signInfo.setWorkSignTime(signInfo.getRuleDate());
        }
        if(SfaWorkSignEnum.WorkSignRuleType.FREE.getVal().equals(ruleType)){
            List<SfaCheckInSignRecordPictureEntity> pictureEntities = sfaCheckInSignRecordPictureService.list(Wrappers.lambdaQuery(SfaCheckInSignRecordPictureEntity.class).eq(SfaCheckInSignRecordPictureEntity::getSignRecordId, id));
            List<SfaCheckInSignRecordPictureRespVo> recordPictureRespVos = CrmBeanUtil.copyList(pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        }else {
            List<SfaWorkSignPictureEntity> pictureEntities = sfaWorkSignPictureService.list(Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity::getWsRecordId, id));
            List<SfaCheckInSignRecordPictureRespVo> recordPictureRespVos = CrmBeanUtil.copyList(pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        }
        // 考勤地点状态
        signInfo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc(signInfo.getWsPlaceStatus()));
        return signInfo;
    }

    /**
     * 考勤明细报表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo) {
        Page<SfaSignDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setRuleDateRange(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        List<SfaSignDetailRespVo> list = mapper.signDetail(page, reqVo);
        if(list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc(vo.getWorkSignStatus()));
                vo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc(vo.getRuleType()));
                if(StringUtils.isNotEmpty(vo.getWorkSignTime())) {
                    vo.setWorkSignTime(vo.getRuleDate() + " " + vo.getWorkSignTime());
                } else {
                    vo.setWorkSignTime(vo.getRuleDate());
                }

                // 考勤照片  不返回照片了，详情里查
//                if(SfaWorkSignEnum.WorkSignRuleType.FREE.getVal().equals(vo.getRuleType())) {
//                    if(StringUtils.isNotEmpty(vo.getId())) {
//                        vo.setSignPictures(pictureService.findList(vo.getId()));
//                    }
//                } else {
//                    if(StringUtils.isNotEmpty(vo.getPicPath()) || StringUtils.isNotEmpty(vo.getPicUrl())) {
//                        SfaCheckInSignRecordPictureRespVo pictureRespVo = new SfaCheckInSignRecordPictureRespVo();
//                        pictureRespVo.setPicPath(vo.getPicPath());
//                        pictureRespVo.setPicUrl(vo.getPicUrl());
//                        vo.setSignPictures(Arrays.asList(pictureRespVo));
//                    }
//                }
                // 考勤地点状态
                vo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc(vo.getWsPlaceStatus()));
            });
        }
        return PageResult.<SfaSignDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    protected Map<String, SfaMonthSignRespVo> getUserMap(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo){
        String nowDay = new Integer(LocalDate.now().getDayOfMonth()).toString();
        // 查询月不是当前月时，获取查询月最后一天
        LocalDate localDate = LocalDate.parse(reqVo.getYearMonth()+"-01");
        if(LocalDate.now().getMonthValue() != localDate.getMonthValue()) {
            nowDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() + "";
        }
        // 把用户数据存放在map中，方便赋值
        Map<String, SfaMonthSignRespVo> userInfoMap = new HashMap<>();
        for(SfaMonthSignRespVo vo : list) {
            userInfoMap.put(vo.getUserName(), vo);
            vo.setNowDay(nowDay);
        }
        return userInfoMap;
    }

    protected MonthSignReportQueryContext loadMonthSignReportQueryContext(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo){
        MonthSignReportQueryContext context = new MonthSignReportQueryContext();
        context.setYearMonth(reqVo.getYearMonth());
        Map<String, SfaMonthSignRespVo> userInfoMap = this.getUserMap(list, reqVo);

        List<String> userNames = new ArrayList<>(userInfoMap.keySet());
//            this.sfaWorkSignRecordService.lambdaQuery().eq(SfaWorkSignRecordEntity :: getRuleDate, reqVo.getYearMonth())
        Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockIn = mapper.monthSignDaysInfo(context.getYearMonth(), SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal(), userNames)
                .stream().collect(Collectors.groupingBy(v -> {return v.getUserName() + v.getRuleDate();}
                        , Collectors.toMap(SfaMonthWorkSignRecordRespVo :: getSfaSignTimeId
                                , v -> v, (SfaMonthWorkSignRecordRespVo, sfaMonthSignDaysInfoRespVo2) -> sfaMonthSignDaysInfoRespVo2)));

        Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockOut = mapper.monthSignDaysInfo(context.getYearMonth(), SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal(), userNames)
                .stream().collect(Collectors.groupingBy(v -> {return v.getUserName() + v.getRuleDate();}
                , Collectors.toMap(SfaMonthWorkSignRecordRespVo :: getSfaSignTimeId
                                , v -> v, (SfaMonthWorkSignRecordRespVo, sfaMonthSignDaysInfoRespVo2) -> sfaMonthSignDaysInfoRespVo2)));


        List<SfaLeaveEntity> leaveEntities = this.leaveMapper.selectList(Wrappers.lambdaQuery(SfaLeaveEntity.class)
                .in(SfaLeaveEntity :: getUserName, userNames)
                .ge(SfaLeaveEntity :: getBeginTime, context.getBeginDate())
                .le(SfaLeaveEntity :: getEndTime, context.getEndDate())
                .eq(SfaLeaveEntity :: getBpmStatus, SfaCommonEnum.dataBpmStatus.PASS.getValue()));
        Map<String, MonthSignReportQueryContext.LeaveDetail> userDayMapOfLeave = this.resolveLeaveDetail(leaveEntities);
        Map<String, MonthSignReportQueryContext.LeaveCancelDetail> leaveIdDayMapOfLeaveCancel;
        if(leaveEntities.size() > 0){
            List<SfaLeaveCancelEntity> cancelEntities = this.cancelService.lambdaQuery().
                    in(SfaLeaveCancelEntity::getLeaveId, leaveEntities.stream()
                            .map(SfaLeaveEntity :: getId).collect(Collectors.toList())).list();
            leaveIdDayMapOfLeaveCancel = this.resolveLeaveCancelDetail(cancelEntities);
        }else{
            leaveIdDayMapOfLeaveCancel = Maps.newHashMap();
        }

        List<SfaWorkOvertimeTimeInfoEntity> overtimeTimeInfoEntities = this.sfaWorkOvertimeTimeInfoService.lambdaQuery()
                .in(SfaWorkOvertimeTimeInfoEntity :: getUserName, userNames)
                .between(SfaWorkOvertimeTimeInfoEntity :: getOvertimeDate, context.getBeginDate(), context.getEndDate()).list();
        Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime = this.resolveOvertimeTimeInfoDetail(overtimeTimeInfoEntities);
//        List<SfaExceptionReportEntity> exceptionReportEntities = this.sfaExceptionReportService.lambdaQuery().in(SfaExceptionReportEntity :: getUserName, userNames)
//                .ge(SfaExceptionReportEntity :: getBeginTime, context.getBeginDate())
//                .le(SfaExceptionReportEntity :: getEndTime, context.getEndDate())
//                .eq(SfaExceptionReportEntity :: getBpmStatus, SfaCommonEnum.dataBpmStatus.PASS.getValue()).list();
//        Map<String, SfaExceptionReportEntity> userDayMapOfExceptionReport = this.resolveUserDayMapOfExceptionReport(exceptionReportEntities);
        context.setUserInfoMap(userInfoMap);
        context.setUserDayMapOfClockIn(userDayMapOfClockIn);
        context.setUserDayMapOfClockOut(userDayMapOfClockOut);
        context.setUserDayMapOfLeave(userDayMapOfLeave);
        context.setLeaveIdDayMapOfLeaveCancel(leaveIdDayMapOfLeaveCancel);
        context.setUserDayMapOfOvertimeTime(userDayMapOfOvertimeTime);
//        context.setUserDayMapOfExceptionReport(userDayMapOfExceptionReport);
        return context;
    }
    
    protected Map<String, SfaExceptionReportEntity> resolveUserDayMapOfExceptionReport(List<SfaExceptionReportEntity> exceptionReportEntities){
        Map<String, SfaExceptionReportEntity> userDayMapOfExceptionReport = Maps.newHashMap();
        for (SfaExceptionReportEntity exceptionReportEntity : exceptionReportEntities) {
            LocalDate begin = LocalDate.parse(exceptionReportEntity.getBeginTime(), CrmDateUtils.yyyyMMdd);
            LocalDate end = LocalDate.parse(exceptionReportEntity.getEndTime(), CrmDateUtils.yyyyMMdd);

            for (int i = 0; ; i++){
                LocalDate localDate = begin.plusDays(i);
                if(localDate.compareTo(end) > 0){
                    break;
                }
                String userDay = exceptionReportEntity.getUserName() + localDate.format(CrmDateUtils.yyyyMMdd);
                userDayMapOfExceptionReport.put(userDay, exceptionReportEntity);
            }
        }
        return userDayMapOfExceptionReport;
    }

    protected Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> resolveOvertimeTimeInfoDetail(List<SfaWorkOvertimeTimeInfoEntity> overtimeTimeInfoEntities){
        Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime = Maps.newHashMap();
        for (SfaWorkOvertimeTimeInfoEntity overtimeTimeInfoEntity : overtimeTimeInfoEntities) {
            MonthSignReportQueryContext.OvertimeTimeInfoDetail leaveDetail = MonthSignReportQueryContext.OvertimeTimeInfoDetail.build(overtimeTimeInfoEntity);
            String userDay = leaveDetail.getUserName() + leaveDetail.getLeaveDate();
            //之前解析过的请假信息
            MonthSignReportQueryContext.OvertimeTimeInfoDetail leaveDetailResolved = userDayMapOfOvertimeTime.get(userDay);
            if(null != leaveDetailResolved){
                //合并两次请假信息
                leaveDetail = MonthSignReportQueryContext.OvertimeTimeInfoDetail.merge(leaveDetailResolved, leaveDetail);
            }
            userDayMapOfOvertimeTime.put(userDay, leaveDetail);

        }

        return userDayMapOfOvertimeTime;
    }

    protected Map<String, MonthSignReportQueryContext.LeaveDetail> resolveLeaveDetail(List<SfaLeaveEntity> leaveEntities){
        Map<String, MonthSignReportQueryContext.LeaveDetail> userDayMapOfLeave = Maps.newHashMap();
        for (SfaLeaveEntity leaveEntity : leaveEntities) {
            List<SfaApplyTimeInfoReqVo> timeInfoList = SfaSignUtils.fillTimeInfo(
                    JSON.parseArray(leaveEntity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class)
                    , leaveEntity.getBeginTime(), leaveEntity.getEndTime()
            );
            for (SfaApplyTimeInfoReqVo timeInfoReqVo : timeInfoList) {
                MonthSignReportQueryContext.LeaveDetail leaveDetail = MonthSignReportQueryContext.LeaveDetail.build(timeInfoReqVo, leaveEntity);
                String userDay = leaveDetail.getUserName() + leaveDetail.getLeaveDate();
                //之前解析过的请假信息
                MonthSignReportQueryContext.LeaveDetail leaveDetailResolved = userDayMapOfLeave.get(userDay);
                if(null != leaveDetailResolved){
                    //合并两次请假信息
                    leaveDetail = MonthSignReportQueryContext.LeaveDetail.merge(leaveDetailResolved, leaveDetail);
                }
                userDayMapOfLeave.put(userDay, leaveDetail);
            }

        }

        return userDayMapOfLeave;
    }

    protected Map<String, MonthSignReportQueryContext.LeaveCancelDetail> resolveLeaveCancelDetail(List<SfaLeaveCancelEntity> leaveCancelEntities){
        Map<String, MonthSignReportQueryContext.LeaveCancelDetail> userDayMapOfLeave = Maps.newHashMap();
        for (SfaLeaveCancelEntity leaveCancelEntity : leaveCancelEntities) {
            List<SfaApplyTimeInfoReqVo> timeInfoList = SfaSignUtils.fillTimeInfo(
                    JSON.parseArray(leaveCancelEntity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class)
                    , leaveCancelEntity.getBeginTime(), leaveCancelEntity.getEndTime()
            );
            for (SfaApplyTimeInfoReqVo timeInfoReqVo : timeInfoList) {
                MonthSignReportQueryContext.LeaveCancelDetail leaveDetail = MonthSignReportQueryContext.LeaveCancelDetail.build(timeInfoReqVo, leaveCancelEntity);
                String leaveIdDay = leaveDetail.getLeaveId() + leaveDetail.getLeaveDate();
                //之前解析过的请假信息
                MonthSignReportQueryContext.LeaveCancelDetail leaveDetailResolved = userDayMapOfLeave.get(leaveIdDay);
                if(null != leaveDetailResolved){
                    //合并两次请假信息
                    leaveDetail = MonthSignReportQueryContext.LeaveCancelDetail.merge(leaveDetailResolved, leaveDetail);
                }
                userDayMapOfLeave.put(leaveIdDay, leaveDetail);
            }

        }

        return userDayMapOfLeave;
    }
    /**
     * 月度考勤报表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo) {
        // 分页查询用户信息
        Page<SfaMonthSignRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaMonthSignRespVo> list = mapper.monthSignUserInfoForPage(page, reqVo);

        this.loadMonthSignDetail(list, reqVo);
        return PageResult.<SfaMonthSignRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
    @Override
    public List<SfaMonthSignRespVo> monthSignListByUsers(SfaMonthSignReqVo reqVo) {
        // 分页查询用户信息
        List<SfaMonthSignRespVo> list = mapper.monthSignUserInfoForUser(reqVo);

        this.loadMonthSignDetail(list, reqVo);
        return list;
    }
    /**
     * 加载月度考勤详情
     * @param list
     * @param reqVo
     */
    protected SfaMonthSignRespVo loadMonthSignDetail(List<SfaMonthSignRespVo> list, SfaMonthSignReqVo reqVo){
        // 用户每天考勤状态信息
        if(list != null && list.size() > 0) {
            MonthSignReportQueryContext context = this.loadMonthSignReportQueryContext(list, reqVo);
//            Map<String, Map<String, SfaMonthSignDaysInfoRespVo>> userDayMapOfClockIn = context.getUserDayMapOfClockIn();
//            Map<String, Map<String, SfaMonthSignDaysInfoRespVo>> userDayMapOfClockOut = context.getUserDayMapOfClockOut();
            Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockIn = context.getUserDayMapOfClockIn();
            Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockOut = context.getUserDayMapOfClockOut();
            Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime = context.getUserDayMapOfOvertimeTime();
            final Map<String, SfaMonthSignRespVo> userInfoMap = context.getUserInfoMap();
            //2022-1-7 重新计算请假
            SfaMonthSignRespVo leave = userInfoMap.get(reqVo.getByUserName());
            Map<String, MonthSignReportQueryContext.LeaveDetail> userDayMapOfLeave = context.getUserDayMapOfLeave();
            userDayMapOfLeave.entrySet().forEach(item -> {
                MonthSignReportQueryContext.LeaveDetail value = item.getValue();
                if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(value.getLeaveType())) { // 全天请假
                    leave.addLeaveDays(BigDecimal.ONE);
                } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(value.getLeaveType())) { // 上午请假
                    leave.addLeaveDays(new BigDecimal(0.5));
                } else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(value.getLeaveType())) { // 下午请假
                    leave.addLeaveDays(new BigDecimal(0.5));
                }
            });


//            // 查询用户考勤按天考勤明细信息
//            List<SfaMonthSignDaysInfoRespVo> daysInfoList = mapper.monthSignDaysInfo(reqVo.getYearMonth(), new ArrayList<>(userInfoMap.keySet()));
            // 汇总计算月报信息
            userDayMapOfClockIn.forEach((userDay, clockInMap) -> {
                Map<String, SfaMonthWorkSignRecordRespVo> clockOutMap = userDayMapOfClockOut.get(userDay);
                if(null == clockOutMap){
                    throw new BusinessException("数据异常，没有查询到签退考勤记录");
                }

                //收集该用户当天的考勤明细数据
                List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos = this.collectSignDaysInfo(context, clockInMap, clockOutMap, userDay);
                if(daysInfoRespVos.size() == 0){
                    return;
                }
                MonthSignReportQueryContext.OvertimeTimeInfoDetail overtimeTimeInfoDetail = userDayMapOfOvertimeTime.get(userDay);
                String overtimeType = null;
                if(null != overtimeTimeInfoDetail){
                    overtimeType = overtimeTimeInfoDetail.getTimeType();
                }
                SfaMonthSignDaysInfoRespVo daysInfoRespVoTemp = daysInfoRespVos.get(0);
                int dayOfMonth = LocalDate.parse(daysInfoRespVoTemp.getRuleDate()).getDayOfMonth();
                // 请假类型
                String leaveTypeOfDay = this.getLeaveType(context, daysInfoRespVoTemp.getRuleDate(), userDay);
                //超出当日且未请假不返回
                LocalDate signTime = LocalDate.parse(daysInfoRespVoTemp.getRuleDate(), CrmDateUtils.yyyyMMdd);
                if (signTime.isAfter(LocalDate.now()) && StringUtils.isEmpty(leaveTypeOfDay)){
                    return;
                }
                SfaMonthSignRespVo monthSign = userInfoMap.get(daysInfoRespVoTemp.getUserName());
                String signMust = null;
                for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
                    signMust = daysInfoRespVo.getSignMust();
                    // 规定必须打卡
                    if(YesNoEnum.yesNoEnum.YES.getValue().equals(signMust)) {

                        if(WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(daysInfoRespVo.getSignOrNonType())) { // 特殊日期不打卡。考勤状态设置为正常
                            daysInfoRespVo.setCiSignTime(daysInfoRespVo.getGotoTime());
                            daysInfoRespVo.setCoSignTime(daysInfoRespVo.getGooffTime());
                            daysInfoRespVo.setCiSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                            daysInfoRespVo.setCoSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                        }
                        // 按照考勤规则设置状态
                        this.signRuleStatus(monthSign, daysInfoRespVo, leaveTypeOfDay);

                    } else { // 不打卡
                        // 有加班时
                        if(StringUtils.isNotEmpty(overtimeType)) {
                            this.countingWorkTimes(monthSign, daysInfoRespVo, dayOfMonth);
                        }
                    }

//                    ciSignStatus.add(daysInfoRespVo.getCiSignStatus());
//                    coSignStatus.add(daysInfoRespVo.getCoSignStatus());
                }
                if(YesNoEnum.yesNoEnum.YES.getValue().equals(signMust)){
//                    if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveTypeOfDay)) { // 全天请假
//                        monthSign.addLeaveDays(BigDecimal.ONE);
//                    } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveTypeOfDay)) { // 上午请假
//                        monthSign.addLeaveDays(new BigDecimal(0.5));
//                    } else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveTypeOfDay)) { // 下午请假
//                        monthSign.addLeaveDays(new BigDecimal(0.5));
//                    }

                    this.countingLeaveStatus(monthSign, daysInfoRespVos, leaveTypeOfDay);
                }else{
                    this.nonSifnRuleStatus(monthSign, dayOfMonth, overtimeType);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(overtimeType)){
                        //统计正常出勤
                        this.countingSingDays(monthSign, daysInfoRespVos);
                    }
                }




            });
            return userInfoMap.get(reqVo.getByUserName());
        }
        return null;
    }

    protected void countingStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String leaveType, int dayOfMonth){
        // 获取考勤状态值
        String statusStr = SfaWorkSignEnum.SignRuleStatus.getDesc(dayInfo.signStatus());
        if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) { // 全天请假
            statusStr = LEAVE_STATUS_STATIC;
        } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) { // 上午请假
            statusStr = LEAVE_STATUS_STATIC + PLUS_STR + statusStr;
        } else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) { // 下午请假
            statusStr = statusStr + PLUS_STR + LEAVE_STATUS_STATIC;
        }
        // 设置当天状态值
        setMonthSignValue(monthSign, SfaMonthSignRespVo.DAY_STATIC + dayOfMonth, statusStr, ",");


    }

    /**
     * 统计月度出勤相关数据
     * @param monthSign
     * @param leaveType
     */
    protected void countingLeaveStatus(SfaMonthSignRespVo monthSign, List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos, String leaveType){
        //没有请假才统计
        if(org.apache.commons.lang3.StringUtils.isNotBlank(leaveType)){
            return;
        }
        //当天的考勤时段数
//        int signTimeSize = daysInfoRespVos.size();
        boolean absenteeism = false;
        for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
            //没有请假才统计
            monthSign.addGoToWorkDaysl(BigDecimal.ONE);
            String signStatus = daysInfoRespVo.signStatus();
            if(SfaWorkSignEnum.SignRuleStatus.LATE.getVal().equals(signStatus)){
                // 统计迟到
                monthSign.addLateDays(1);
            }
            if(SfaWorkSignEnum.SignRuleStatus.EARLY.getVal().equals(signStatus)){
                // 统计早退
                monthSign.addEarlyDays(1);
            }
            if(SfaWorkSignEnum.SignRuleStatus.LATE_EARLY.getVal().equals(signStatus)){
                // 统计迟到早退
                monthSign.addLateDays(1);
                monthSign.addEarlyDays(1);
            }
            // 旷工统计
            if(SfaWorkSignEnum.SignRuleStatus.MORNING_TRUANCY.getVal().equals(signStatus)
                    || SfaWorkSignEnum.SignRuleStatus.MORNING_EARLY.getVal().equals(signStatus)
                    || SfaWorkSignEnum.SignRuleStatus.MORNING_NIGHT.getVal().equals(signStatus)
                    || SfaWorkSignEnum.SignRuleStatus.NIGHT_TRUANCY.getVal().equals(signStatus)
                    || SfaWorkSignEnum.SignRuleStatus.NIGHT_LATE.getVal().equals(signStatus)){
                absenteeism = true;
            }

//            if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) { // 上午请假
//                monthSign.addLeaveDays(new BigDecimal(0.5));
//            } else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) { // 下午请假
//                monthSign.addLeaveDays(new BigDecimal(0.5));
//            }else if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) { // 全天请假
//                monthSign.addLeaveDays(BigDecimal.ONE);
//            }
        }
        // 旷工统计
        if(absenteeism){
            monthSign.addAbsenteeismDays(BigDecimal.ONE);
        }
        //统计正常出勤
        this.countingSingDays(monthSign, daysInfoRespVos);

    }

    /**
     * 统计正常出勤
     * @param monthSign
     */
    protected void countingSingDays(SfaMonthSignRespVo monthSign, List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos){
        boolean normal = true;
        for (SfaMonthSignDaysInfoRespVo daysInfoRespVo : daysInfoRespVos) {
            String signStatus = daysInfoRespVo.signStatus();
            if(!SfaWorkSignEnum.SignRuleStatus.ATTENDANCE.getVal().equals(signStatus)){
                normal = false;
            }
        }
        // 正常出勤统计
        if (normal) {
            monthSign.addNormal(BigDecimal.ONE);
        }
    }

    protected List<SfaMonthSignDaysInfoRespVo> collectSignDaysInfo(MonthSignReportQueryContext context, Map<String, SfaMonthWorkSignRecordRespVo> clockInMap
            , Map<String, SfaMonthWorkSignRecordRespVo> clockOutMap, String userDay){
//        Map<String, SfaExceptionReportEntity> userDayMapOfExceptionReport = context.getUserDayMapOfExceptionReport();
        List<SfaMonthSignDaysInfoRespVo> daysInfoRespVos = Lists.newArrayList();
        clockInMap.forEach((sfaSignTimeId, clockIn) -> {
            SfaMonthWorkSignRecordRespVo clockOut = clockOutMap.get(sfaSignTimeId);
            if(null == clockOut){
                throw new BusinessException("数据异常，没有查询到[" + userDay + "]的签退考勤记录");
            }
            SfaMonthSignDaysInfoRespVo vo = CrmBeanUtil.copy(clockIn, SfaMonthSignDaysInfoRespVo.class);
            vo.setCiSignTime(clockIn.getWorkSignTime());
            vo.setCiSignStatus(clockIn.getWorkSignStatus());
            vo.setGotoTime(clockIn.getSfaSignTime());

            vo.setCoSignTime(clockOut.getWorkSignTime());
            vo.setCoSignStatus(clockOut.getWorkSignStatus());
            vo.setGooffTime(clockOut.getSfaSignTime());

//            vo.setExceptionReport(userDayMapOfExceptionReport.containsKey(userDay));
//            MonthSignReportQueryContext.OvertimeTimeInfoDetail overtimeTimeInfoDetail = userDayMapOfWorkOvertime.get(userDay);
//            if(null != overtimeTimeInfoEntity){
//                vo.setOvertimeType(overtimeTimeInfoEntity.getTimeType());
//            }
            daysInfoRespVos.add(vo);
        });
        return daysInfoRespVos.stream().sorted(new Comparator<SfaMonthSignDaysInfoRespVo>() {
            @Override
            public int compare(SfaMonthSignDaysInfoRespVo o1, SfaMonthSignDaysInfoRespVo o2) {
                String time1 = o1.getGotoTime();
                if(org.apache.commons.lang3.StringUtils.isBlank(time1)){
                    time1 = CrmDateUtils.TIME_STR_00;
                }
                String time2 = o2.getGotoTime();
                if(org.apache.commons.lang3.StringUtils.isBlank(time2)){
                    time2 = CrmDateUtils.TIME_STR_00;
                }
                LocalTime gotoTime1 = LocalTime.parse(time1, CrmDateUtils.HHmmss);
                LocalTime gotoTime2 = LocalTime.parse(time2, CrmDateUtils.HHmmss);
                return gotoTime2.compareTo(gotoTime1);
            }
        }).collect(Collectors.toList());
    }

    /**
     * 根据请假和销假信息获取最终请假类型
     * @param ruleDate 计算日期
     * @return null 未请假，1全天，2上午，3下午
     */
    protected String getLeaveType(MonthSignReportQueryContext context, String ruleDate, String userDay) {
        MonthSignReportQueryContext.LeaveDetail leaveDetail = context.getUserDayMapOfLeave().get(userDay);
        if(null == leaveDetail){
            return null;
        }
        Map<String, MonthSignReportQueryContext.LeaveCancelDetail> leaveIdDayMapOfLeaveCancel = context.getLeaveIdDayMapOfLeaveCancel();

        MonthSignReportQueryContext.LeaveCancelDetail leaveCancelDetail = leaveIdDayMapOfLeaveCancel.get(leaveDetail.getLeaveId() + ruleDate);
        String leaveType = leaveDetail.getLeaveType();
        String cancelType = null;
        if(null != leaveCancelDetail){
            cancelType = leaveCancelDetail.getLeaveType();
        }
        if(StringUtils.isEmpty(leaveType)) {
            return null;
        }
        if(leaveType.equals(cancelType)) {
            return null;
        }
        if(StringUtils.isEmpty(cancelType)) {
            return leaveType;
        }
        // 销假申请时，判断了只能是请假全天，销假非全天。其他销假必须一致销假
        // 上午销假
        if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(cancelType)) {
            return SfaCommonEnum.dataTimeType.AFTERNOON.getValue();
        }
        // 下午销假
        return SfaCommonEnum.dataTimeType.FORENOON.getValue();
    }

    private static final String PLUS_STR = "+"; // 状态连接符
    private static final String LEAVE_STATUS_STATIC = "请假"; // 请假考勤状态值常量
    private static final String WEEKEND_STATUS_STATIC = "休息";
    private static final String OVERTIME_STATUS_STATIC = "加班";

    /**
     * 工作日考勤
     * @param monthSign 考勤信息对象
     * @param dayInfo 当日考勤详情
     * @param leaveType 请假类型
     */
    protected void signRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String leaveType) {
        int dayOfMonth = LocalDate.parse(dayInfo.getRuleDate()).getDayOfMonth();
        this.countingStatus(monthSign, dayInfo, leaveType, dayOfMonth);

        //统计工时
       this.countingWorkTimes(monthSign, dayInfo, dayOfMonth);
        //异常报备
//        if(dayInfo.isExceptionReport()){
//            BigDecimal dayTime = new BigDecimal(0);
//            //按照规则（报备全天的则按配置的下班时间-上班时间）
//            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getGotoTime()), LocalTime.parse(dayInfo.getGooffTime()));
//            if ((dayInfo.getCiSignStatus()).equals(dayInfo.getCoSignStatus())){
//                //报备全天
//                int hour =(int) time/6;
//                float endTime = ((float)hour)/(float)10;
//                dayTime = new BigDecimal(endTime+"");
//                monthSign.addAllTimes(dayTime);
//            }else {
//                //报备半天（如存在报备半天的则按照配置的（下班时间-上班时间）/2）
//                int hour =(int) time/12;
//                float endTime = ((float)hour)/(float)10;
//                dayTime = new BigDecimal(endTime+"");
//                monthSign.addAllTimes(dayTime);
//            }
//            // 设置工时值
//            setMonthSignValue(monthSign, SfaMonthSignRespVo.DAY_STATIC+SfaMonthSignRespVo.DAY_TIME+LocalDate.parse(date).getDayOfMonth(), dayTime);
//        }
    }

    /**
     * 统计工时
     * @param monthSign
     * @param dayInfo
     * @param dayOfMonth
     */
    protected void countingWorkTimes(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, int dayOfMonth){
        // 统计工时-正常考勤时
        if(StringUtils.isNotEmpty(dayInfo.getCiSignTime()) && StringUtils.isNotEmpty(dayInfo.getCoSignTime())) {
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
            int hour =(int) time/6;
            float endTime = ((float)hour)/(float)10;
            BigDecimal dayTime = new BigDecimal(endTime + "");
            monthSign.addAllTimes(dayTime);
            // 设置工时值
            setMonthSignValue(monthSign, SfaMonthSignRespVo.DAY_STATIC + SfaMonthSignRespVo.DAY_TIME + dayOfMonth, dayTime, "+");
        }
    }

    /**
     * 非工作日统计
     * @param monthSign 考勤信息对象
     * @param overtimeType 工作日调整
     */
    protected void nonSifnRuleStatus(SfaMonthSignRespVo monthSign, int dayOfMonth, String overtimeType) {

        // 默认状态
        String statusStr = WEEKEND_STATUS_STATIC;
        // 加班时状态
        if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(1));
        } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC + PLUS_STR + statusStr;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(overtimeType)) {
            statusStr = statusStr + PLUS_STR + OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else {
            monthSign.addOffDays(BigDecimal.ONE);
        }
        // 设置当天状态值
        setMonthSignValue(monthSign, SfaMonthSignRespVo.DAY_STATIC + dayOfMonth, statusStr, ",");


    }

    /**
     * 设置考勤信息值(反射设置)
     * @param key
     * @param value
     */
    private void setMonthSignValue(SfaMonthSignRespVo monthSign, String key, Object value, String delimiter) {
        if(null == value){
            return;
        }
        // 反射设置当天状态值
        try {
            Class c = monthSign.getClass();
            Field f = c.getDeclaredField(key);
            f.setAccessible(true);
            Object object = f.get(monthSign);
            if(null != object){
                value = object.toString() + delimiter + value.toString();
            }
            f.set(monthSign, value.toString());
        }catch(Exception e) {
            throw new BusinessException("考勤后台报错", e);
        }
    }

    /**
     * 请假申请明细
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo) {
        Page<SfaLeaveApplyDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaLeaveApplyDetailRespVo> list = leaveMapper.leaveApplyDetail(page, reqVo);

        if(list != null && list.size() > 0) {
            List<String> ids = list.stream().map(SfaLeaveApplyDetailRespVo :: getId).collect(Collectors.toList());
//            sfaSignApplyAttachmentService.lambdaQuery().in(SfaSignApplyAttachmentEntity :: getSourceId, ids)
//                    .eq(SfaSignApplyAttachmentEntity :: getApplyType, WorkSignEnum.signApplyType.LEAVE.getValue()).list();
            SfaLeaveCancelReqVo param = new SfaLeaveCancelReqVo();
            param.setLeaveIdList(ids);
            Map<String, List<SfaLeaveCancelRespVo>> cancelMap = leaveCancelService.findList(param).stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo :: getLeaveId));
            list.forEach(vo -> {
                List<SfaLeaveCancelRespVo> temp = cancelMap.get(vo.getId());
                if(null == temp){
                    temp = Lists.newArrayList();
                }
                vo.setLeaveCancelRespVo(temp);
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc(vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc(vo.getLeaveType()));
            });
        }
        return PageResult.<SfaLeaveApplyDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 请假申请汇总
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo) {
        Page<SfaLeaveApplySummaryRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        // 查询分页信息
        List<SfaLeaveApplySummaryRespVo> summarylist = leaveMapper.leaveApplySummary(page, reqVo);
        // 查询明细列表信息
        if(summarylist != null && summarylist.size() > 0) {
            // 获取用户信息
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap =this.getUserOrgInfoByUserNames(summarylist.stream().map(SfaLeaveApplySummaryRespVo::getUserName).collect(Collectors.toList()));

            // 获取请假明细列表，拼装为 userName-List<>
            SfaLeaveApplyDetailReqVo detailReqVo = CrmBeanUtil.copy(reqVo, SfaLeaveApplyDetailReqVo.class);
            detailReqVo.setBeginTime(reqVo.getLeaveDateStart());
            detailReqVo.setEndTime(reqVo.getLeaveDateEnd());
            detailReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            List<SfaLeaveApplyDetailRespVo> detailRespVoList = leaveMapper.leaveApplyDetail(null, detailReqVo);
            Map<String, List<SfaLeaveApplyDetailRespVo>> userDetailMap = detailRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveApplyDetailRespVo::getUserName));
            // 获取请假销假列表，拼装为 leaveId-List<>
            SfaLeaveCancelReqVo cancelReqVo = new SfaLeaveCancelReqVo();
            cancelReqVo.setLeaveIdList(detailRespVoList.stream().map(SfaLeaveApplyDetailRespVo::getId).collect(Collectors.toList()));
            List<SfaLeaveCancelRespVo> leaveCancelRespVoList = cancelService.findList(cancelReqVo);
            Map<String, List<SfaLeaveCancelRespVo>> leaveCancelMap = leaveCancelRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo::getLeaveId));

            String beginTime = reqVo.getLeaveDateStart();
            String endTime = reqVo.getLeaveDateEnd();

            // 循环计算请假时长
            for(SfaLeaveApplySummaryRespVo summaryVo : summarylist) {
                MdmPositionUserOrgRespVo mdmUser = mdmUserMap.get(summaryVo.getUserName());
                if(mdmUser != null) {
                    summaryVo.setPosName(mdmUser.getPositionName());
                    summaryVo.setParentOrgName(mdmUser.getParentOrgName());
                    summaryVo.setOrgName(mdmUser.getOrgName());
                }

                List<SfaLeaveApplyDetailRespVo> list = userDetailMap.get(summaryVo.getUserName());
                for(SfaLeaveApplyDetailRespVo vo : list) {
                    // 当前申请原时长
                    BigDecimal count = SfaSignUtils.countCreateNewTimeInfo(beginTime, endTime, JSON.parseArray(vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
                    // 扣除非工作日
                    if(StringUtils.isNotEmpty(vo.getNonWorkDateListJson())) {
                        List<SfaApplyTimeInfoReqVo> nonWorkTimeInfoList = JSON.parseArray(vo.getNonWorkDateListJson(), SfaApplyTimeInfoReqVo.class);
                        for(SfaApplyTimeInfoReqVo v1 : nonWorkTimeInfoList) {
                            BigDecimal nonWorkCount = SfaSignUtils.countCreateNewTimeInfo(beginTime, endTime,Arrays.asList(v1));
                            count = count.subtract(nonWorkCount);
                        }
                    }
                    // 扣除销假
                    if(leaveCancelMap.get(vo.getId()) != null) {
                        List<SfaLeaveCancelRespVo> leaveCancelRespVoList1 = leaveCancelMap.get(vo.getId());
                        for(SfaLeaveCancelRespVo v1 : leaveCancelRespVoList1){
                            BigDecimal cancelWorkCount = SfaSignUtils.countCreateNewTimeInfo(beginTime, endTime, v1.getTimeInfoList());
                            count = count.subtract(cancelWorkCount);
                        };
                    }

                    // 根据请假类型 累加统计值
                    if(SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setAnnualLeave(summaryVo.getAnnualLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.PERSONAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPersonalLeave(summaryVo.getPersonalLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.MARRIAGE_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setMarriageLeave(summaryVo.getMarriageLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.FUNERAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setFuneralLeave(summaryVo.getFuneralLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.PATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPaternityLeave(summaryVo.getPaternityLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setDaysOff(summaryVo.getDaysOff().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.SICK_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setSickLeave(summaryVo.getSickLeave().add(count));
                    } else if(SfaCommonEnum.leaveTypeEnum.MATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setMaternityLeave(summaryVo.getMaternityLeave().add(count));
                    }
                }
            }
        }
        return PageResult.<SfaLeaveApplySummaryRespVo>builder()
                .data(summarylist)
                .count(page.getTotal())
                .build();
    }

    /**
     * 工作日调整申请明细
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo) {
        Page<SfaWorkOvertimeDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkOvertimeDetailRespVo> list = overtimeMapper.workOvertimeDetail(page, reqVo);
        if(list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc(vo.getBpmStatus()));
            });
        }
        return PageResult.<SfaWorkOvertimeDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 工作日调整申请汇总
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo) {
        Page<SfaWorkOvertimeSummaryRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());

        // 获取数据字典加班申请有效期配置, 如果没配置默认为0
        reqVo.setIndate(overtimeService.getOvertimeIndate());

        List<SfaWorkOvertimeSummaryRespVo> list = overtimeMapper.workOvertimeSummary(page, reqVo);
        if(list != null && list.size() > 0 && list.get(0) != null) {
            // 获取用户信息
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap =this.getUserOrgInfoByUserNames(list.stream().map(SfaWorkOvertimeSummaryRespVo::getUserName).collect(Collectors.toList()));
            list.forEach(vo -> {
                MdmPositionUserOrgRespVo mdmUser = mdmUserMap.get(vo.getUserName());
                if(mdmUser != null) {
                    vo.setPosName(mdmUser.getPositionName());
                    vo.setParentOrgName(mdmUser.getParentOrgName());
                    vo.setOrgName(mdmUser.getOrgName());
                    String orgCode = mdmUser.getOrgCode();
                    //主职位组织
                    vo.setOrgName(mdmUser.getOrgName());
                    //组织的上级组织
                    MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(orgCode);
                    if(null != mdmOrgRespVo){
                        vo.setParentOrgName(mdmOrgRespVo.getParentName());
                    }
                }
            });
        }
        return PageResult.<SfaWorkOvertimeSummaryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 异常报备申请明细报表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo) {
        Page<SfaExceptionReportDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaExceptionReportDetailRespVo> list = mapper.exceptionReportDetail(page, reqVo);
        List<String> ids = Lists.newArrayList();
        for (SfaExceptionReportDetailRespVo sfaExceptionReportDetailRespVo : list) {
            ids.addAll(Stream.of(sfaExceptionReportDetailRespVo.getExceptionRecordIds().split(",")).collect(Collectors.toList()));
        }
        if(ids.size() > 0) {
            Map<String, SfaWorkSignRecordRespVo> recordRespVos = mapper.findRecordsById(ids)
                    .stream().collect(Collectors.toMap(SfaWorkSignRecordRespVo :: getId, v -> v, (t, t2) -> t2));
            list.forEach(vo -> {
                //获取异常打卡记录编号
                List<SfaWorkSignRecordRespVo> tempRecords = Stream.of(vo.getExceptionRecordIds().split(",")).collect(Collectors.toList())
                        .stream().map(v -> recordRespVos.get(v)).filter(v -> null != v).collect(Collectors.toList());
                tempRecords.sort((o1, o2) -> {
                    String time1 = o1.getSfaSignTime();
                    if(org.apache.commons.lang3.StringUtils.isBlank(time1)){
                        time1 = CrmDateUtils.TIME_STR_00;
                    }
                    LocalTime localTime1 = LocalTime.parse(time1, CrmDateUtils.HHmmss);

                    String time2 = o2.getSfaSignTime();
                    if(org.apache.commons.lang3.StringUtils.isBlank(time2)){
                        time2 = CrmDateUtils.TIME_STR_00;
                    }
                    LocalTime localTime2 = LocalTime.parse(time2, CrmDateUtils.HHmmss);

                    return localTime1.compareTo(localTime2);
                });

                //取出补打卡类型和时间作拼接并返回
                String collect = tempRecords.stream().map(recordRespVo -> {
                    if ((StringUtils.isNotEmpty(recordRespVo.getSfaSignTime()))){
                        return recordRespVo.getWorkSignDesc() + "(" + recordRespVo.getSfaSignTime() + ")";
                    }else {
                        return recordRespVo.getWorkSignDesc() + "("  + ")";
                    }
                }).collect(Collectors.joining("、"));
                vo.setExceptionRecordType(collect);
                vo.setClockDate(vo.getBeginTime());
                vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc(vo.getBpmStatus()));
            });
        }
        return PageResult.<SfaExceptionReportDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 出差申请明细报表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTravelRespVo> travelDetail(SfaTravelReqVo reqVo) {
        return travelService.findList(reqVo);
    }

    /**
     * 获取用户当前主职位信息
     * @return
     */
    @Override
    public MdmPositionUserOrgRespVo getUserOrgInfo(String userName) {
        // 设置上级组织信息
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(userName);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List<MdmPositionUserOrgRespVo> userList = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), true);
        if(userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("用户信息不存在");
        }
        if(userList.size() != 1) {
            throw new BusinessException("用户主职位存在多个");
        }
        return userList.get(0);
    }

    /**
     * 批量查询用户信息
     * @param userNameList
     * @return
     */
    public Map<String, MdmPositionUserOrgRespVo> getUserOrgInfoByUserNames(List<String> userNameList) {
        // 设置上级组织信息
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserNameList(userNameList);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List<MdmPositionUserOrgRespVo> userList = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), true);
        if(userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("用户信息不存在");
        }
        return userList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, v -> v, (t, t2) -> t2));
    }


    /**
     * 根据审核人任务id查询工作日调整明细
     * @param auditTaskId
     * @return
     */
    @Override
    public SfaWorkOvertimeRespVo queryOvertiem(String auditTaskId) {

        return overtimeService.queryByAuditTaskId(auditTaskId);
    }

    /**
     * 根据审核人任务id查询请假明细
     * @param auditTaskId
     * @return
     */
    @Override
    public SfaLeaveRespVo queryleave(String auditTaskId) {

        return leaveService.queryByAuditTaskId(auditTaskId);
    }

    /**
     * 根据审核人任务id查询异常报备明细
     * @param auditTaskId
     * @return
     */
    @Override
    public SfaExceptionReportDetailRespVo queryException(String auditTaskId) {
        SfaExceptionReportDetailRespVo respVo = mapper.queryByAuditTaskId(auditTaskId);
        AssertUtils.isNotNull(respVo, "记录不存在");
        List<String> ids = Stream.of(respVo.getExceptionRecordIds().split(",")).collect(Collectors.toList());
        List<SfaWorkSignRecordRespVo> recordRespVos = mapper.findRecordsById(ids);
        AssertUtils.isNotNull(recordRespVos, "记录不存在");
        //取出补打卡类型和时间作拼接并返回
        String collect = recordRespVos.stream().map(e -> {
            if ((StringUtils.isNotEmpty(e.getSfaSignTime()))){
                return e.getWorkSignDesc() + "(" + e.getSfaSignTime() + ")";
            }else {
                return e.getWorkSignDesc() + "("  + ")";
            }
        }).collect(Collectors.joining("、"));
        respVo.setExceptionRecordType(collect);
        respVo.setClockDate(respVo.getBeginTime());
        respVo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc(respVo.getBpmStatus()));
        SfaSignApplyAttachmentEntity one = sfaSignApplyAttachmentService.lambdaQuery().eq(SfaSignApplyAttachmentEntity::getSourceId, respVo.getId()).one();
        if (null != one){
            respVo.setAttachmentListJson(one.getAttachmentListJson());
        }

        return respVo;
    }

    /**
     * 根据审核任务id查询销假明细
     * @param auditTaskId
     * @return
     */
    @Override
    public SfaLeaveCancelInfoRespVo queryLeaveCancel(String auditTaskId) {

        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){
            {setAuditTaskIdList(Arrays.asList(auditTaskId));}
        };
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = leaveCancelService.findInfoList(reqVo);

        if(pageResult == null || pageResult.getCount() != 1) {
            throw new BusinessException("审核任务ID错误");
        }
        return pageResult.getData().get(0);
    }

    /**
     * 根据审核人任务id查询出差明细
     * @param auditTaskId
     * @return
     */
    @Override
    public SfaTravelRespVo queryTravel(String auditTaskId) {
        return travelService.queryByAuditTaskId(auditTaskId);
    }


    protected void dd(SfaMonthSignReqVo reqVo){

    }
    @Override
    public SfaMonthSignRespVo appUserByMonthSign(SfaMonthSignReqVo reqVo) {

        if (null == reqVo){
            reqVo = new SfaMonthSignReqVo();
            reqVo.setByUserName(UserUtils.getUser().getUsername());
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(reqVo.getUserName())){
            reqVo.setByUserName(reqVo.getUserName());
            reqVo.setUserName(null);
        }

        if (null != reqVo && StringUtils.isNotEmpty(reqVo.getTimeType()) && WorkSignEnum.TimeType.SY.getVal().equals(reqVo.getTimeType())){
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(Calendar.MONTH, -1);
            Date m = c.getTime();
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(m));
        }else {
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        // 查询用户信息
        List<SfaMonthSignRespVo> list = mapper.monthSignUserInfoForUser(reqVo);

        SfaMonthSignRespVo respVo = null;
        // 用户每天考勤状态信息
        if(list != null && list.size() > 0) {

            respVo = this.loadMonthSignDetail(list, reqVo);
            if(respVo == null){
                respVo = list.get(0);
            }
            //出差天数
            SfaTravelReqVo sfaTravelReqVo = new SfaTravelReqVo();
            sfaTravelReqVo.setTravelUserNames(reqVo.getByUserName());
            sfaTravelReqVo.setYearMonth(reqVo.getYearMonth());
            sfaTravelReqVo.setBpmStatus(ActivitiOperateTypeEnum.PASS.getCode());
            List<SfaTravelRespVo> sfaTravelRespVoList = travelService.findDataList(sfaTravelReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaTravelRespVoList)){
                Integer  travelDays = 0;
                for (SfaTravelRespVo travelRespVo:sfaTravelRespVoList){
                    try{
                        Date endDate = DateUtil.date_sdf.parse(travelRespVo.getEndTime());
                        Date beginDate = DateUtil.date_sdf.parse(travelRespVo.getBeginTime());
                        if (!travelRespVo.getBeginTime().contains(sfaTravelReqVo.getYearMonth())){
                            beginDate = DateUtil.date_sdf.parse(sfaTravelReqVo.getYearMonth()+"-01");
                        }if(endDate.getTime()>new Date().getTime()){
                            endDate = new Date();
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(endDate);
                        calendar.add(Calendar.DATE, 1);
                        endDate = calendar.getTime();
                        int datsInt = DateUtil.getDayCount(beginDate,endDate);
                        if (datsInt<0){
                            datsInt = -1*datsInt;
                        }
                        travelDays = travelDays + datsInt;
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
                respVo.setTravelDays(travelDays);
            }
            //日报数
            SfaWorkSummaryReqVo sfaWorkSummaryReqVo = new SfaWorkSummaryReqVo();
            sfaWorkSummaryReqVo.setUserCode(reqVo.getUserName());
            sfaWorkSummaryReqVo.setYearMonth(reqVo.getYearMonth());
            sfaWorkSummaryReqVo.setSummaryType(SfaWorkSummaryEnum.LectureType.DAILY.getVal());
            Integer dailyDays = sfaWorkSummaryService.getSfaWorkSummaryPrimaryByCount(sfaWorkSummaryReqVo);
            if (null==dailyDays){
                dailyDays = 0;
            }
            respVo.setDailyDays(dailyDays);
            BigDecimal goToWorkDays = respVo.getGoToWorkDays();//需要上班天数
            Integer notDailyDays = Integer.valueOf(goToWorkDays.toString()) - dailyDays < 0 ? 0 : Integer.valueOf(goToWorkDays.toString()) - dailyDays;
            respVo.setNotDailyDays(notDailyDays);
        }
        if(null == respVo){
            respVo = new SfaMonthSignRespVo();
        }
        return respVo;
    }

}
