package com.biz.crm.worksignrule.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 特殊日期 
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignspecial")
@Api(tags = "特殊日期 ")
public class SfaWorkSignSpecialController {
    @Autowired
    private ISfaWorkSignSpecialService sfaWorkSignSpecialService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignSpecialRespVo>> list(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        PageResult<SfaWorkSignSpecialRespVo> result=sfaWorkSignSpecialService.findList(sfaWorkSignSpecialReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignSpecialRespVo> query(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        SfaWorkSignSpecialRespVo respVo=sfaWorkSignSpecialService.query(sfaWorkSignSpecialReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        sfaWorkSignSpecialService.save(sfaWorkSignSpecialReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        sfaWorkSignSpecialService.update(sfaWorkSignSpecialReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        sfaWorkSignSpecialService.deleteBatch(sfaWorkSignSpecialReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        sfaWorkSignSpecialService.enableBatch(sfaWorkSignSpecialReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo) {
        sfaWorkSignSpecialService.disableBatch(sfaWorkSignSpecialReqVo);
        return Result.ok("禁用成功");
    }
}
