package com.biz.crm.worksignrule.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤规则-打卡人员 
 * 
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
public interface SfaWorkSignPersonnelMapper extends BaseMapper<SfaWorkSignPersonnelEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    List<SfaWorkSignPersonnelRespVo> findList(Page<SfaWorkSignPersonnelRespVo> page, @Param("vo") SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);


    /**
     * 关联规则表查询考勤组织
     * @param wspCodes 组织编码集合
     * @param nonRuleCode 非指定规则码
     * @param ruleCode 指定规则码
     * @param enableStatus 规则状态
     * @return
     */
    List<SfaWorkSignPersonnelRespVo> findListJoinRule(@Param("wspCodes")List<String> wspCodes,
                                                      @Param("nonRuleCode") String nonRuleCode,
                                                      @Param("ruleCode") String ruleCode,
                                                      @Param("enableStatus") String enableStatus);

    /**
     * 删除
     * @param sfaWorkSignPersonnelReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

}
