package com.biz.crm.worksignrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 考勤规则-打卡地点 实体类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_place")
@CrmTable(name = "sfa_work_sign_place", tableNote = "考勤规则-打卡地点",indexes = {
        @Index(name = "SFA_WORK_SIGN_PLACE_INDEX1",columnList = "RULE_CODE")
})
public class SfaWorkSignPlaceEntity extends CrmExtTenEntity<SfaWorkSignPlaceEntity> {


    /**
     * 序号 序号
     */
    @CrmColumn(name = "wsp_no", length = 32, note = "序号 序号")
    private String wspNo;

    /**
     * 打卡地点名称 打卡地点名称
     */
    @CrmColumn(name = "place_name", length = 100, note = "打卡地点名称 打卡地点名称")
    private String placeName;

    /**
     * 地点经度 地点经度
     */
    @CrmColumn(name = "place_lngin", length = 32, note = "地点经度 地点经度")
    private String placeLngin;

    /**
     * 地点纬度 地点纬度
     */
    @CrmColumn(name = "place_latin", length = 32, note = "地点纬度 地点纬度")
    private String placeLatin;

    /**
     * 打卡类型(CLOCK_ALL:上下班打卡,CLOCK_IN:上班签到,CLOCK_OUT:下班签退)
     */
    @CrmColumn(name = "place_sign_type", length = 20, note = "打卡类型(CLOCK_ALL:上下班打卡,CLOCK_IN:上班签到,CLOCK_OUT:下班签退)")
    private String placeSignType;

    /**
     * 打卡范围 打卡范围(100:100米,300:300米,500:500米)
     */
    @CrmColumn(name = "place_range", length = 32, note = "打卡范围 打卡范围(100:100米,300:300米,500:500米)")
    private String placeRange;


    /**
     * 规则编码;规则编码
     */
    @CrmColumn(name = "rule_code", length = 32, note = "规则编码;规则编码")
    private String ruleCode;
}
