package com.biz.crm.worksignrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 考勤规则;考勤规则实体类
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_rule")
@CrmTable(name = "sfa_work_sign_rule", tableNote = "考勤规则" ,indexes = {
        @Index(name = "sfa_work_sign_rule_index1",columnList ="rule_code" ,unique = true)
})
public class SfaWorkSignRuleEntity extends CrmExtTenEntity<SfaWorkSignRuleEntity> {

    /**
     * 考勤规则解析天数
     */
    public static final int RULE_RESOLVE_DAYS = 7;

    /**
     * 规则编码;规则编码
     */
    @CrmColumn(name = "rule_code", length = 32, note = "规则编码;规则编码")
    private String ruleCode;

    /**
     * 规则名称;规则名称
     */
    @CrmColumn(name = "rule_name", length = 100, note = "规则名称;规则名称")
    private String ruleName;

    /**
     * 规则类型;规则类型(STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则)
     */
    @CrmColumn(name = "rule_type", length = 64, note = "规则类型;规则类型(STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则)")
    private String ruleType;

    /**
     * 电子围栏;电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)
     */
    @CrmColumn(name = "electron_fence", length = 64, note = "电子围栏;电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)")
    private String electronFence;

    /**
     * 工作日;(0:星期一;1:星期二;2:星期三;3:星期四;4:星期五;5:星期六;6:星期日)
     */
    @CrmColumn(name = "working_day", length = 64, note = "工作日;(0:星期一;1:星期二;2:星期三;3:星期四;4:星期五;5:星期六;6:星期日)")
    private String workingDay;

    /**
     * 工作日调整申请时是否遵循此规则(前端气泡)（Y/N 默认N）
     */
    @CrmColumn(name = "non_working_day_sign_astrict", length = 4, note = "工作日调整申请时是否遵循此规则(前端气泡)（Y/N 默认N）")
    private String nonWorkingDaySignAstrict;

    /**
     * 节假日;节假日(Y：同步中国节假日节假日期间不用打卡)
     */
    @CrmColumn(name = "holiday_whether", length = 64, note = "节假日;节假日(Y：同步中国节假日节假日期间不用打卡)")
    private String holidayWhether;

    /**
     * 拍照打卡;拍照打卡(Y:员工打卡时必须拍照)
     */
    @CrmColumn(name = "wsr_photograph", length = 64, note = "拍照打卡;拍照打卡(Y:员工打卡时必须拍照)")
    private String wsrPhotograph;

    /**
     * 下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)
     */
    @CrmColumn(name = "gooff_work_sign_astrict", length = 128, note = "下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)")
    private String gooffWorkSignAstrict;
    /**
     * 规则生效日期(NOW:立即生效/TOMORROW:明日生效)
     */
    @CrmColumn(name = "rule_effective", length = 64, note = "规则生效日期(NOW:立即生效/TOMORROW:明日生效)")
    private String ruleEffective;


}
