package com.biz.crm.worksignrule.service;

import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 考勤规则-打卡人员 接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
public interface ISfaWorkSignPersonnelService extends IService<SfaWorkSignPersonnelEntity> {

    /**
     * 列表
     * @param sfaWorkSignPersonnelReqVo
     * @return PageResult<SfaWorkSignPersonnelRespVo>
     */
    PageResult<SfaWorkSignPersonnelRespVo> findList(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

     /**
     * 关联规则表查询考勤组织
     * @param wspCodes 组织编码集合
     * @param nonRuleCode 非指定规则码
     * @param ruleCode 指定规则码
     * @param enableStatus 规则状态
     * @return
     */
    List<SfaWorkSignPersonnelRespVo> findListJoinRule(List<String> wspCodes, String nonRuleCode, String ruleCode, String enableStatus);

    /**
     * 根据规则编码查询 Mapping 列表
     * @param ruleCodes
     * @return
     */
    Map<String, List<SfaWorkSignPersonnelEntity>> selectMappingByRuleCodes(Set<String> ruleCodes);

    /**
     * 查询
     * @param sfaWorkSignPersonnelReqVo
     * @return SfaWorkSignPersonnelRespVo
     */
    SfaWorkSignPersonnelRespVo query(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 新增
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    void save(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 更新
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    void update(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 删除
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 启用
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    void enableBatch(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 禁用
     * @param sfaWorkSignPersonnelReqVo
     * @return
     */
    void disableBatch(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo);

    /**
     * 根据考勤规则编码和考勤范围卫星编码查询列表
     * 注：允许参数为空，参数为空则查出所有记录
     * @param ruleCode
     * @param codeType  {@link WorkSignEnum.codeType}
     * @return
     */
    List<SfaWorkSignPersonnelEntity> findByRuleCodeAndCodeType(String ruleCode, String codeType);
}

