package com.biz.crm.worksignrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPlaceRespVo;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 考勤规则-打卡地点 接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
public interface ISfaWorkSignPlaceService extends IService<SfaWorkSignPlaceEntity> {

    /**
     * 列表
     * @param sfaWorkSignPlaceReqVo
     * @return PageResult<SfaWorkSignPlaceRespVo>
     */
    PageResult<SfaWorkSignPlaceRespVo> findList(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);
    /**
     * 根据规则编码查询 Mapping 列表
     * @param ruleCodes
     * @return
     */
    Map<String, List<SfaWorkSignPlaceEntity>> selectMappingByRuleCodes(Set<String> ruleCodes);
    /**
     * 查询
     * @param sfaWorkSignPlaceReqVo
     * @return SfaWorkSignPlaceRespVo
     */
    SfaWorkSignPlaceRespVo query(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 新增
     * @param sfaWorkSignPlaceReqVo
     * @return
     */
    void save(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 更新
     * @param sfaWorkSignPlaceReqVo
     * @return
     */
    void update(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 删除
     * @param sfaWorkSignPlaceReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 启用
     * @param sfaWorkSignPlaceReqVo
     * @return
     */
    void enableBatch(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 禁用
     * @param sfaWorkSignPlaceReqVo
     * @return
     */
    void disableBatch(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);

    /**
     * 新增,编辑,校验
     * @param sfaWorkSignPlaceReqVo
     */
    void saveCheck(SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo);
}

