package com.biz.crm.worksignrule.service.impl;


import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 执行考勤规则,上下文数据
 *  @author: luoqi
 *  @Date: 2020-11-12 17:29
 *  @version: V1.0
 *  @Description:
 */
@Data
public class ExecuteSignRuleContext {

    public ExecuteSignRuleContext cloneContext(){
        ExecuteSignRuleContext context = new ExecuteSignRuleContext(this.rules);
        context.setSignDate(this.signDate);
        context.setRuleEntityMap(this.ruleEntityMap);
        context.setRuleCodes(this.ruleCodes);
        context.setSpecialMapping(this.specialMapping);
        context.setTimeMapping(this.timeMapping);
        context.setPlaceMapping(this.placeMapping);
        context.setPersonnelMapping(this.personnelMapping);
        context.setPosLevelListMap(this.posLevelListMap);
        context.setOrgToRuleMap(this.orgToRuleMap);
        context.setOrgAndPosLevelToRuleMap(this.orgAndPosLevelToRuleMap);
        context.setOrgPositionMappingCurrentY(this.orgPositionMappingCurrentY);
        return context;
    }


    public ExecuteSignRuleContext(List<SfaWorkSignRuleEntity> rules){
        this.rules = rules;
        this.ruleEntityMap = rules.stream().collect(Collectors.toMap(SfaWorkSignRuleEntity::getRuleCode, vo->vo, (k1, k2) -> k2));
        this.ruleCodes = rules.stream().map(SfaWorkSignRuleEntity :: getRuleCode).collect(Collectors.toSet());
    }

//############################   需要的前置数据   #################################################
    //考勤日期
    private String signDate;
    //可执行的规则列表
    private List<SfaWorkSignRuleEntity> rules;
    //规则编号键值对
    private Map<String, SfaWorkSignRuleEntity> ruleEntityMap;
    //可执行的规则编码列表
    private Set<String> ruleCodes;
    //特殊日期 ruleCode-list
    private Map<String, List<SfaWorkSignSpecialEntity>> specialMapping;
    //打卡时间 ruleCode-list
    private Map<String, List<SfaWorkSignTimeEntity>> timeMapping;
    //打卡地点 ruleCode-list
    private Map<String, List<SfaWorkSignPlaceEntity>> placeMapping;
    //考勤组织 ruleCode-list
    private Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping;
    //规则考勤职位级别
    private Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap;
    //单个组织对应考勤规则 orgCode-(层级，ruleCode)。当前组织对应该规则最近
    private Map<String, OrgToRule> orgToRuleMap;
    //单个组织对应考勤规则 orgCode-(层级，ruleCode)。当前组织对应该规则最近
    private Map<String, OrgToRule> orgAndPosLevelToRuleMap;
    //组织下的职位和用户信息-当前组织人员 orgCode-list
    private Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentY;
//    //组织下的职位和用户信息-当前组织和下级组织 orgCode-list
//    private Map<String, List<MdmPositionUserOrgRespVo>> orgPositionMappingCurrentN;


//############################   计算出来的数据   #################################################
    //解析结果状态
    private Boolean status = true;
    //当前计算的组织
    @Getter
    @Setter
    private String orgCodeNow;
    @Getter
    @Setter
    private String orgNameNow;
    //上级组织编码
    @Getter
    @Setter
    private String parentOrgCodeNow;
    @Getter
    @Setter
    private String parentOrgNameNow;
    //已计算出来的考勤明细
    @Getter
    @Setter
    private List<SfaWorkSignRuleInfoEntity> ruleInfoEntities = Lists.newArrayList();
    public void addRuleInfo(SfaWorkSignRuleInfoEntity ruleInfoEntitie){
        if(null == ruleInfoEntities){
            return;
        }
        this.ruleInfoEntities.add(ruleInfoEntitie);
    }
    //已计算出来的考勤记录
    @Getter
    @Setter
    private List<SfaWorkSignRecordEntity> recordEntities = Lists.newArrayList();
    public void addRecord(List<SfaWorkSignRecordEntity> recordEntities){
        if(null == recordEntities){
            return;
        }
        this.recordEntities.addAll(recordEntities);
    }
    //已被考勤规则计算过的用户
    @Getter
    private Set<String> users = Sets.newHashSet();

    public boolean addUser(String user){
        if(StringUtils.isBlank(user) || this.users.contains(user)){
            return false;
        }
        this.users.add(user);
        return true;
    }


    /**
     * 组织对应的层级及规则信息
     */
    @Data
    public static class OrgToRule {
        private Integer leave; // 当前层级
        private String ruleCode; // 使用规则信息
        public OrgToRule(Integer leave, String ruleCode) {
            this.leave = leave;
            this.ruleCode = ruleCode;
        }
    }

}
