package com.biz.crm.worksignrule.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.google.common.collect.Lists;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SignRuleUtils {
    private SignRuleUtils(){}
    private static ISfaWorkSignRuleService sfaWorkSignRuleService = SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignRuleService.class);
    private static ISfaWorkSignTimeService iSfaWorkSignTimeService = SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignTimeService.class);
    private static ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService = SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignPersonnelService.class);

    /**
     *命中给定用户、范围下的考勤规则
     * @param userOrgCode 用户组织
     * @param personnelEntitiesGroupByOrgCode 用户组织、上级组织下的规则范围列表
     * @param personnelEntityRuleCodeMappingOfLevelCode 用户职位级别下的规则
     * @param userOrgAndParentOrg 用户组织、上级组织
     * @return
     */
    public static SfaWorkSignRuleEntity hitUserSignRuleCode(String userOrgCode, Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntitiesGroupByOrgCode
            , Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode
            , List<MdmOrgRespVo> userOrgAndParentOrg, Map<String, SfaWorkSignRuleEntity> ruleEntityMap){
        List<SfaWorkSignPersonnelEntity> personnelEntitiesOfOrgCode = personnelEntitiesGroupByOrgCode.get(userOrgCode);
        //优先使用用户的直属组织命中规则
        SignRuleCode ruleCode = doHitRuleCode(personnelEntitiesOfOrgCode, personnelEntityRuleCodeMappingOfLevelCode, ruleEntityMap);
        SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode = ruleCode.getHitOfOrgCodeAndLevelCode();
        if(null != hitOfOrgCodeAndLevelCode){
            return hitOfOrgCodeAndLevelCode;
        }
        SfaWorkSignRuleEntity hitOfOrgRuleEntity = null;
        // orgCode -> ParentCode,每个组织对自己上级的映射
//        Map<String, String> orgCodeMapParentCode = userOrgAndParentOrg.stream().collect(Collectors.toMap(MdmOrgRespVo :: getOrgCode, MdmOrgRespVo :: getParentCode, (s, s2) -> s2));
        Map<String, String> orgCodeMapParentCode = userOrgAndParentOrg.stream().collect(HashMap::new, (k, v) -> k.put(v.getOrgCode(), v.getParentCode()), HashMap::putAll);
        //用户直属组织未能命中，则向上级组织查找，直到最顶级组织
        while (orgCodeMapParentCode.containsKey(userOrgCode)){
            if(null == hitOfOrgRuleEntity && null != ruleCode.getHitOfOrgCode()){
                hitOfOrgRuleEntity = ruleCode.getHitOfOrgCode();
            }
            String parentCode = orgCodeMapParentCode.get(userOrgCode);
            if(StringUtils.isBlank(parentCode)){
                //没有上级，则使用组织（组织树上离用户最近的那个）命中的规则
                return hitOfOrgRuleEntity;
            }
            personnelEntitiesOfOrgCode = personnelEntitiesGroupByOrgCode.get(userOrgCode);
            //尝试命中规则
            ruleCode = doHitRuleCode(personnelEntitiesOfOrgCode, personnelEntityRuleCodeMappingOfLevelCode, ruleEntityMap);
            hitOfOrgCodeAndLevelCode = ruleCode.getHitOfOrgCodeAndLevelCode();
            if(null != hitOfOrgCodeAndLevelCode){
                return hitOfOrgCodeAndLevelCode;
            }

            userOrgCode = parentCode;
        }
        return hitOfOrgRuleEntity;
    }

    /**
     * 在给定的范围内尝试命中一个考勤规则
     * @param personnelEntitiesOfOrgCode 某个组织下的所有范围配置
     * @param personnelEntityRuleCodeMappingOfLevelCode 某个职位级别下所有范围配置
     * @return
     */
    public static SignRuleCode doHitRuleCode(List<SfaWorkSignPersonnelEntity> personnelEntitiesOfOrgCode
            , Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode, Map<String, SfaWorkSignRuleEntity> ruleEntityMap){
        if(CollectionUtils.isEmpty(personnelEntitiesOfOrgCode)){
            return SignRuleCode.builder().build();
        }
        SfaWorkSignPersonnelEntity entity = null;
        for (SfaWorkSignPersonnelEntity personnelEntity : personnelEntitiesOfOrgCode) {
            String ruleCode = personnelEntity.getRuleCode();
            if(personnelEntityRuleCodeMappingOfLevelCode.containsKey(ruleCode) && ruleEntityMap.containsKey(ruleCode)){
                return SignRuleCode.builder().hitOfOrgCodeAndLevelCode(ruleEntityMap.get(ruleCode)).build();
            }
            entity = personnelEntity;
        }
        if(null == entity || StringUtils.isBlank(entity.getRuleCode())){
            return SignRuleCode.builder().build();
        }
        return SignRuleCode.builder().hitOfOrgCode(ruleEntityMap.get(entity.getRuleCode())).build();
    }

    /**
     * 获取改用户的考勤规则
     * @param primaryPosition
     */
    public static SfaWorkSignRuleEntity getUserSignRuleCode(MdmPositionRespVo primaryPosition){
        if(null == primaryPosition){
            return null;
        }

        String positionLevelCode = primaryPosition.getPositionLevelCode();

        if(org.apache.commons.lang3.StringUtils.isBlank(positionLevelCode)){
            throw new BusinessException("该用户主职位信息缺失职位级别编码！");
        }
        Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode = iSfaWorkSignPersonnelService.lambdaQuery()
                .eq(SfaWorkSignPersonnelEntity::getWspCode, positionLevelCode)
                .eq(SfaWorkSignPersonnelEntity::getCodeType, WorkSignEnum.codeType.POS_LEVEL.getVal())
                .eq(SfaWorkSignPersonnelEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(SfaWorkSignPersonnelEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()).list()
                .stream().collect(Collectors.toMap(SfaWorkSignPersonnelEntity::getRuleCode, v -> v, (t, t2) -> t2));
        String userOrgCode = primaryPosition.getOrgCode();
        List<MdmOrgRespVo> userOrgAndParentOrg = OrgUtil.getParentOrgListIncludeSelf(userOrgCode);
        Set<String> orgCodes = userOrgAndParentOrg.stream().map(MdmOrgRespVo :: getOrgCode).collect(Collectors.toSet());
        Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntitiesGroupByOrgCode = iSfaWorkSignPersonnelService.lambdaQuery()
                .in(SfaWorkSignPersonnelEntity::getWspCode, orgCodes)
                .eq(SfaWorkSignPersonnelEntity::getCodeType, WorkSignEnum.codeType.ORG.getVal())
                .eq(SfaWorkSignPersonnelEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(SfaWorkSignPersonnelEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()).list()
                .stream().collect(Collectors.groupingBy(SfaWorkSignPersonnelEntity::getWspCode));
        Map<String, SfaWorkSignRuleEntity> ruleEntityList = sfaWorkSignRuleService.lambdaQuery()
                .eq(SfaWorkSignRuleEntity:: getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaWorkSignRuleEntity :: getDelFlag, CrmEnableStatusEnum.ENABLE.getCode()).list()
                .stream().collect(Collectors.toMap(SfaWorkSignRuleEntity :: getRuleCode, v -> v, (t, t2) -> t2));
        return hitUserSignRuleCode(userOrgCode, personnelEntitiesGroupByOrgCode
                , personnelEntityRuleCodeMappingOfLevelCode, userOrgAndParentOrg, ruleEntityList);

    }


    public static SfaWorkSignRuleInfoEntity buildSfaWorkSignRuleInfoEntity(SfaWorkSignRuleEntity ruleEntity, MdmPositionRespVo primaryPosition, String ruleDate){
        SfaWorkSignRuleInfoEntity infoEntity = SfaWorkSignRuleInfoEntity.buildRuleInfoEntity(ruleEntity, ruleDate);
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(primaryPosition.getOrgCode());
        infoEntity.setOrgCode(mdmOrgRespVo.getOrgCode());
        infoEntity.setOrgName(mdmOrgRespVo.getOrgName());
        infoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
        infoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        infoEntity.setPosCode(primaryPosition.getPositionCode());
        infoEntity.setPosName(primaryPosition.getPositionName());
        infoEntity.setRealName(primaryPosition.getFullName());
        infoEntity.setUserName(primaryPosition.getUserName());
        return infoEntity;
    }
    public static List<SfaWorkSignRecordEntity> buildSfaWorkSignRecordEntity(SfaWorkSignRuleInfoEntity infoEntity){
        List<SfaWorkSignTimeEntity> sfaWorkSignTimeEntities = iSfaWorkSignTimeService.lambdaQuery().eq(SfaWorkSignTimeEntity :: getRuleCode, infoEntity.getRuleCode()).list();
        List<SfaWorkSignRecordEntity> recordEntities = Lists.newArrayList();
        for(SfaWorkSignTimeEntity sfaWorkSignTimeEntity : sfaWorkSignTimeEntities){
            List<SfaWorkSignRecordEntity> temp = SfaWorkSignRecordEntity.buildClockInOut(infoEntity, sfaWorkSignTimeEntity);
            //组装用户考勤记录
            recordEntities.addAll(temp);
        }
        return recordEntities;
    }

    @Data
    @Builder
    protected static class SignRuleCode{
        //组织+职位级别命中的规则
        private SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode;
        //组织命中的规则
        private SfaWorkSignRuleEntity hitOfOrgCode;
    }
}
