package com.biz.crm.worksummary.controller;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPrimaryRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksummary.service.ISfaWorkSummaryPrimaryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 工作总结
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@RestController
@RequestMapping("/sfa-work-summary-primary-web")
@Api(tags = "WEB端工作总结")
public class SfaWorkSummaryPrimaryController {
    @Autowired
    private ISfaWorkSummaryPrimaryService sfaWorkSummaryService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryPrimaryRespVo>> list(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        PageResult<SfaWorkSummaryPrimaryRespVo> result=sfaWorkSummaryService.findList(sfaWorkSummaryReqVo);
        return Result.ok(result);
    }

    /**
     * 导出
     */
    @ApiOperation(value = "列表导出")
    @PostMapping("/export")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryPrimaryRespVo>> export(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryReqVo.setIsExport("Y");
        PageResult<SfaWorkSummaryPrimaryRespVo> result=sfaWorkSummaryService.findList(sfaWorkSummaryReqVo);
        return Result.ok(result);
    }

    /**
     * 查询转发列表
     */
    @ApiOperation(value = "查询转发列表")
    @PostMapping("/forward-list")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryPrimaryRespVo>> forwradList(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        PageResult<SfaWorkSummaryPrimaryRespVo> result=sfaWorkSummaryService.forwradList(sfaWorkSummaryReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSummaryPrimaryRespVo> query(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        SfaWorkSummaryPrimaryRespVo respVo=sfaWorkSummaryService.query(sfaWorkSummaryReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增(总结/转发)")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.save(sfaWorkSummaryReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.update(sfaWorkSummaryReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.deleteBatch(sfaWorkSummaryReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.enableBatch(sfaWorkSummaryReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo) {
        sfaWorkSummaryService.disableBatch(sfaWorkSummaryReqVo);
        return Result.ok("禁用成功");
    }
}
