package com.biz.crm.worksummary.mapper;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.worksummary.model.SfaWorkSummaryCommentEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryCommentReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作总结评论记录
 * 
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface SfaWorkSummaryCommentMapper extends BaseMapper<SfaWorkSummaryCommentEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    List<SfaWorkSummaryCommentRespVo> findList(Page<SfaWorkSummaryCommentRespVo> page, @Param("vo") SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 查询评论数
     * @param ids
     * @return
     */
    List<SfaWorkSummaryCommentRespVo> findCountByBusinessIds(@Param("businessIds") List<String> ids);

    /**
     * 查询自己评论过的
     * @param commentPage
     * @param reqVo
     * @return
     */
    List<SfaWorkSummaryCommentRespVo> findCommentList(Page<SfaWorkSummaryCommentRespVo> commentPage, @Param("vo") SfaWorkSummaryPrimaryReqVo reqVo);
}
