package com.biz.crm.worksummary.mapper;

import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPrimaryRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import java.util.List;

/**
 * 工作总结
 * 
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface SfaWorkSummaryPrimaryMapper extends BaseMapper<SfaWorkSummaryPrimaryEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSummaryReqVo
     * @return
     */
    List<SfaWorkSummaryPrimaryRespVo> findList(Page<SfaWorkSummaryPrimaryRespVo> page, @Param("vo") SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 根据查看权限查询
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaWorkSummaryPrimaryRespVo> findListByAuth(Page<SfaWorkSummaryPrimaryRespVo> page, @Param("vo") SfaWorkSummaryPrimaryReqVo reqVo);

    /**
     * 根据Ids查
     * @param reqVo
     * @return
     */
    List<SfaWorkSummaryPrimaryRespVo> findListByIds(@Param("vo") SfaWorkSummaryPrimaryReqVo reqVo);

    /**
     * 查询转发数
     * @param ids
     * @return
     */
    List<SfaWorkSummaryPrimaryRespVo> findForwardSumCountByIds(@Param("ids") List<String> ids);

    /**
     * 查询转发列表
     * @param page
     * @param params
     * @return
     */
    List<SfaWorkSummaryPrimaryRespVo> forwradList(Page<SfaWorkSummaryPrimaryRespVo> page, @Param("vo") SfaWorkSummaryPrimaryReqVo params);

    /**
     * 日报，周报，月报唯一
     * @param reqVo
     * @return
     */
    SfaWorkSummaryPrimaryRespVo findByOnlyOne(@Param("vo") SfaWorkSummaryPrimaryReqVo reqVo);
}
