package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结评论记录实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_comment")
@CrmTable(name = "sfa_work_summary_comment", tableNote = "工作总结评论记录",indexes = {
        @Index(name = "work_summary_comment_index1",columnList = "summary_id")
})
public class SfaWorkSummaryCommentEntity extends CrmExtTenEntity<SfaWorkSummaryCommentEntity> {

    private static final long serialVersionUID = 4192439403082396874L;
    /**
     * 评论内容
     */
    @CrmColumn(name = "comment_desc", length = 200, note = "评论内容")
    private String commentDesc;

    /**
     * 工作动态ID/评论ID
     */
    @CrmColumn(name = "business_id", length = 32, note = "工作动态ID/评论ID")
    private String businessId;

    /**
     * 工作动态（总结）ID
     */
    @CrmColumn(name = "summary_id", length = 32, note = "工作动态（总结）ID")
    private String summaryId;
}
