package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结点赞记录实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_like")
@CrmTable(name = "sfa_work_summary_like", tableNote = "工作总结点赞记录",indexes = {
        @Index(name = "work_summary_like_index1",columnList = "summary_id")
})
public class SfaWorkSummaryLikeEntity extends CrmExtTenEntity<SfaWorkSummaryLikeEntity> {

    private static final long serialVersionUID = 6775095208466983858L;
    /**
     * 被点赞数据ID（工作总结ID/评论ID）
     */
    @CrmColumn(name = "business_id", length = 32, note = "被点赞数据ID（工作总结ID/评论ID）")
    private String businessId;

    /**
     * 工作动态（总结）ID
     */
    @CrmColumn(name = "summary_id", length = 32, note = "工作动态（总结）ID")
    private String summaryId;
}
