package com.biz.crm.worksummary.service;

import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryLikeReqVo;

import java.util.Map;

/**
 * 工作总结点赞记录接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryLikeService extends IService<SfaWorkSummaryLikeEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryLikeReqVo
     * @return PageResult<SfaWorkSummaryLikeRespVo>
     */
    PageResult<SfaWorkSummaryLikeRespVo> findList(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryLikeReqVo
     * @return SfaWorkSummaryLikeRespVo
     */
    SfaWorkSummaryLikeRespVo query(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    SfaWorkSummaryLikeRespVo save(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    void update(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);
}

