package com.biz.crm.worksummary.service;

import com.biz.crm.worksummary.model.SfaWorkSummaryScopeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryScopeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryScopeReqVo;

import java.util.Map;

/**
 * 工作总结可见权限接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryScopeService extends IService<SfaWorkSummaryScopeEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryScopeReqVo
     * @return PageResult<SfaWorkSummaryScopeRespVo>
     */
    PageResult<SfaWorkSummaryScopeRespVo> findList(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryScopeReqVo
     * @return SfaWorkSummaryScopeRespVo
     */
    SfaWorkSummaryScopeRespVo query(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryScopeReqVo
     * @return
     */
    void save(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryScopeReqVo
     * @return
     */
    void update(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryScopeReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryScopeReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryScopeReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryScopeReqVo sfaWorkSummaryScopeReqVo);
}

