package com.biz.crm.worksummary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.*;
import com.biz.crm.util.*;
import com.biz.crm.worksummary.mapper.*;
import com.biz.crm.worksummary.model.*;
import com.biz.crm.worksummary.service.ISfaWorkSummaryPrimaryService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工作总结接口实现
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaWorkSummaryPrimaryExpandImpl")
public class SfaWorkSummaryPrimaryServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaWorkSummaryPrimaryMapper, SfaWorkSummaryPrimaryEntity> implements ISfaWorkSummaryPrimaryService {

    @Resource
    private SfaWorkSummaryPrimaryMapper sfaWorkSummaryPrimaryMapper;

    @Autowired
    private SfaWorkSummaryPictureMapper sfaWorkSummaryPictureMapper;

    @Autowired
    private SfaWorkSummaryAtLogMapper sfaWorkSummaryAtLogMapper;

    @Autowired
    private SfaWorkSummaryScopeMapper sfaWorkSummaryScopeMapper;

    @Autowired
    private SfaWorkSummaryCommentMapper sfaWorkSummaryCommentMapper;

    @Autowired
    private SfaWorkSummaryLikeMapper sfaWorkSummaryLikeMapper;

    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryPrimaryRespVo> findList(SfaWorkSummaryPrimaryReqVo reqVo) {
        reqVo.setIds(Lists.newArrayList());
        //当前登录人
        UserRedis currUser = UserUtils.getUser();
        reqVo.setCurrAccount(currUser.getUsername());
        //登录人组织
        String currOrgcode = currUser.getOrgcode();
        //登录人职位
        String currPoscode = currUser.getPoscode();
        Page<SfaWorkSummaryPrimaryRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        //特殊查询
        String queryType = reqVo.getQueryType();
        //查询@自己的
        if (SfaWorkSummaryEnum.QueryType.AT.getVal().equals(queryType)) {
            Page<SfaWorkSummaryAtLogRespVo> atLogPage = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
            List<SfaWorkSummaryAtLogRespVo> atLogList = sfaWorkSummaryAtLogMapper.findAtLogList(atLogPage, reqVo);
            atLogList.forEach(o -> {
                reqVo.getIds().add(o.getSummaryId());
            });
            page.setTotal(atLogPage.getTotal());
        }

        //查询自己评论过的
        if (SfaWorkSummaryEnum.QueryType.COMMENT.getVal().equals(queryType)) {
            Page<SfaWorkSummaryCommentRespVo> commentPage = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
            List<SfaWorkSummaryCommentRespVo> commentList = sfaWorkSummaryCommentMapper.findCommentList(commentPage, reqVo);
            commentList.forEach(o -> {
                reqVo.getIds().add(o.getSummaryId());
            });
            page.setTotal(commentPage.getTotal());
        }

        //结果
        List<SfaWorkSummaryPrimaryRespVo> list = null;
        //根据权限查
        if (!SfaWorkSummaryEnum.QueryType.AT.getVal().equals(queryType) && !SfaWorkSummaryEnum.QueryType.COMMENT.getVal().equals(queryType)) {
            List<MdmOrgRespVo> orgRespVos = null;
            List<MdmPositionUserOrgRespVo> posRespVos = null;
            MdmPositionUserOrgReqVo posQueryVo = new MdmPositionUserOrgReqVo();
            //posQueryVo.setPrimaryFlag("0");
            posQueryVo.setParentCode(currPoscode);
            posQueryVo.setIncludeEmptyUserPosition(false);
            //权限集合
            Set<String> scopeArray = Sets.newHashSet();
            if (StringUtils.isEmpty(queryType)) {
                //查询组织上级组织
                orgRespVos = OrgUtil.getParentOrgListIncludeSelf(currOrgcode);
                orgRespVos.forEach(o -> {
                    scopeArray.add(o.getOrgCode());
                });
                //查询职位下级职位信息
                posRespVos = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(posQueryVo), true);
                posRespVos.forEach(o -> {
                    scopeArray.add(o.getPositionCode());
                });
                scopeArray.add(SfaWorkSummaryEnum.ScopeType.ALL.getVal());
                scopeArray.add(currUser.getUsername());
            } else if (SfaWorkSummaryEnum.QueryType.SELF.getVal().equals(queryType)) {
                scopeArray.add(currUser.getUsername());
                reqVo.setCreateCode(currUser.getUsername());
            } else if (SfaWorkSummaryEnum.QueryType.POSITION.getVal().equals(queryType)) {
                //查询职位下级职位信息
                posRespVos = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(posQueryVo));
                posRespVos.forEach(o -> {
                    scopeArray.add(o.getPositionCode());
                });
            }
            reqVo.setScopeArray(scopeArray);
            list = sfaWorkSummaryPrimaryMapper.findListByAuth(page, reqVo);
        } else if (!CollectionUtils.isEmpty(reqVo.getIds())) {
            //根据Ids查
            list = sfaWorkSummaryPrimaryMapper.findListByIds(reqVo);
        }
        //数据处理
        if (!CollectionUtils.isEmpty(list)) {
            //创建人
            Set<String> createCodes = Sets.newHashSet();
            //数据ID
            List<String> ids = Lists.newArrayList();
            //转发关联数据
            List<String> summaryIds = Lists.newArrayList();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
                ids.add(o.getId());
                if (!StringUtils.isEmpty(o.getSummaryId())) {
                    summaryIds.add(o.getSummaryId());
                    ids.add(o.getSummaryId());
                }
            });
            //查询@人信息
            List<SfaWorkSummaryAtLogRespVo> atLogRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryAtLogMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap = atLogRespVos.stream()
                    .collect(Collectors.groupingBy(SfaWorkSummaryAtLogRespVo::getBusinessId));
            atLogRespVoMap.forEach((k, v) -> {
                v.forEach(o -> {
                    createCodes.add(o.getAtUserCode());
                });
            });
            //查询转发关联数据
            SfaWorkSummaryPrimaryReqVo forwardQureyVo = new SfaWorkSummaryPrimaryReqVo();
            if (!CollectionUtils.isEmpty(summaryIds)) {
                forwardQureyVo.setIds(summaryIds);
            }
            List<SfaWorkSummaryPrimaryRespVo> forwardRespVos = CollectionUtils.isEmpty(summaryIds)
                    ? Lists.newArrayList() : sfaWorkSummaryPrimaryMapper.findListByIds(forwardQureyVo);
            forwardRespVos.forEach(o -> {
                createCodes.add(o.getCreateCode());
            });
            Map<String, SfaWorkSummaryPrimaryRespVo> forwardMap = forwardRespVos.stream()
                    .collect(Collectors.toMap(SfaWorkSummaryPrimaryRespVo::getId, Function.identity()));

            //查询人员信息
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setPrimaryFlag("1");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List<MdmPositionUserOrgRespVo> userOrgRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(userQueryVo));

            Map<String, MdmPositionUserOrgRespVo> userOrgRespVoMap = userOrgRespVos.stream()
                    .collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));

            //查询点赞数
            List<SfaWorkSummaryLikeRespVo> likeRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryLikeMapper.findCountByBusinessIds(ids);
            Map<String, SfaWorkSummaryLikeRespVo> likeRespVoMap = likeRespVos.stream()
                    .collect(Collectors.toMap(SfaWorkSummaryLikeRespVo::getBusinessId, Function.identity()));
            //查询自己点赞记录
            LambdaQueryWrapper<SfaWorkSummaryLikeEntity> buildLikeQuery = new LambdaQueryWrapper<SfaWorkSummaryLikeEntity>()
                    .eq(SfaWorkSummaryLikeEntity::getCreateCode, currUser.getUsername())
                    .in(SfaWorkSummaryLikeEntity::getBusinessId, ids);
            List<SfaWorkSummaryLikeEntity> summaryLikeEntities = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryLikeMapper.selectList(buildLikeQuery);
            Map<String, SfaWorkSummaryLikeEntity> likedMap = summaryLikeEntities.stream()
                    .collect(Collectors.toMap(SfaWorkSummaryLikeEntity::getBusinessId, Function.identity()));

            //查询评论数
            List<SfaWorkSummaryCommentRespVo> commentRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryCommentMapper.findCountByBusinessIds(ids);
            Map<String, SfaWorkSummaryCommentRespVo> commentRespVoMap = commentRespVos.stream()
                    .collect(Collectors.toMap(SfaWorkSummaryCommentRespVo::getBusinessId, Function.identity()));
            //查询转发数
            List<SfaWorkSummaryPrimaryRespVo> forwardSumCountRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryPrimaryMapper.findForwardSumCountByIds(ids);
            Map<String, SfaWorkSummaryPrimaryRespVo> forwardRespVoMap = forwardSumCountRespVos.stream()
                    .collect(Collectors.toMap(SfaWorkSummaryPrimaryRespVo::getSummaryId, Function.identity()));
            //查询照片
            List<SfaWorkSummaryPictureRespVo> pictureRespVos = !StringUtils.isEmpty(reqVo.getIsExport())
                    ? Lists.newArrayList() : sfaWorkSummaryPictureMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryPictureRespVo>> pictureRespVoMap = pictureRespVos.stream()
                    .collect(Collectors.groupingBy(SfaWorkSummaryPictureRespVo::getBusinessId));

            list.forEach(o -> {
                //转发数据
                if (!StringUtils.isEmpty(o.getSummaryId())) {
                    SfaWorkSummaryPrimaryRespVo forwardRespVo = forwardMap.get(o.getSummaryId());
                    builData(forwardRespVo, pictureRespVoMap, forwardRespVoMap, commentRespVoMap, likeRespVoMap, userOrgRespVoMap, atLogRespVoMap, likedMap);
                    o.setForwardRespVos(forwardRespVo);
                }
                builData(o, pictureRespVoMap, forwardRespVoMap, commentRespVoMap, likeRespVoMap, userOrgRespVoMap, atLogRespVoMap, likedMap);
                //类型描述
                o.setLectureTypeStr(SfaWorkSummaryEnum.LectureType.GETMAP.get(o.getLectureType()));
            });
        }

        return PageResult.<SfaWorkSummaryPrimaryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    private void builData(SfaWorkSummaryPrimaryRespVo o, Map<String, List<SfaWorkSummaryPictureRespVo>> pictureRespVoMap,
                          Map<String, SfaWorkSummaryPrimaryRespVo> forwardRespVoMap, Map<String, SfaWorkSummaryCommentRespVo> commentRespVoMap,
                          Map<String, SfaWorkSummaryLikeRespVo> likeRespVoMap, Map<String, MdmPositionUserOrgRespVo> userOrgRespVoMap,
                          Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap,
                          Map<String, SfaWorkSummaryLikeEntity> likedMap) {
        String id = o.getId();
        //头像
        MdmPositionUserOrgRespVo userOrgRespVo = userOrgRespVoMap.get(o.getCreateCode());
        if (!ObjectUtils.isEmpty(userOrgRespVo)) {
            o.setPhoto(userOrgRespVo.getUserHeadUrl());
        }
        //点赞数
        SfaWorkSummaryLikeRespVo likeRespVo = likeRespVoMap.get(id);
        if (!ObjectUtils.isEmpty(likeRespVo)) {
            o.setLikeSumCount(likeRespVo.getSumCount());
        }
        //评论数
        SfaWorkSummaryCommentRespVo sfaWorkSummaryCommentRespVo = commentRespVoMap.get(id);
        if (!ObjectUtils.isEmpty(sfaWorkSummaryCommentRespVo)) {
            o.setCommentSumCount(sfaWorkSummaryCommentRespVo.getCommentSumCount());
        }
        //转发数
        SfaWorkSummaryPrimaryRespVo summaryPrimaryRespVo = forwardRespVoMap.get(id);
        if (!ObjectUtils.isEmpty(summaryPrimaryRespVo)) {
            o.setForwardSumCount(summaryPrimaryRespVo.getForwardSumCount());
        }
        //照片
        List<SfaWorkSummaryPictureRespVo> pictureList = pictureRespVoMap.get(id);
        if (!CollectionUtils.isEmpty(pictureList)) {
            o.setPictureRespVos(pictureList);
        }
        //@人员
        List<SfaWorkSummaryAtLogRespVo> atLogArray = atLogRespVoMap.get(id);
        if (!CollectionUtils.isEmpty(atLogArray)) {
            atLogArray.forEach(e -> {
                MdmPositionUserOrgRespVo userRespVo = userOrgRespVoMap.get(e.getAtUserCode());
                if (!ObjectUtils.isEmpty(userRespVo)) {
                    e.setAtUserName(userRespVo.getFullName());
                }
            });
            o.setAtLogRespVos(atLogArray);
        }
        //是否已点赞
        SfaWorkSummaryLikeEntity summaryLikeEntity = likedMap.get(id);
        if (!ObjectUtils.isEmpty(summaryLikeEntity)) {
            o.setLiked("Y");
        } else {
            o.setLiked("N");
        }
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaWorkSummaryRespVo
     */
    @Override
    public SfaWorkSummaryPrimaryRespVo query(SfaWorkSummaryPrimaryReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSummaryPrimaryReqVo reqVo) {
        //当前登录人信息
        UserRedis user = UserUtils.getUser();
        reqVo.setCreateCode(user.getUsername());
        validation(reqVo);
        //判断新增总结还是转发
        if (SfaWorkSummaryEnum.IsForward.Y.getVal().equals(reqVo.getIsForward())) {
            ValidateUtils.validate(reqVo.getSummaryId(), "转发关联工作总结Id不能为空");
            //查询总结信息
            SfaWorkSummaryPrimaryEntity summaryEntity = sfaWorkSummaryPrimaryMapper.selectById(reqVo.getSummaryId());
            if (ObjectUtils.isEmpty(summaryEntity)) {
                throw new BusinessException("未查询到转发关联的工作总结");
            } else if (summaryEntity.getCreateCode().equals(user.getUsername())) {
                throw new BusinessException("不能转发自己的动态!");
            }
            reqVo.setLectureType(summaryEntity.getLectureType());
        }
        SfaWorkSummaryPrimaryEntity summaryEntity = CrmBeanUtil.copy(reqVo, SfaWorkSummaryPrimaryEntity.class);
        this.save(summaryEntity);
        //动态ID
        String dynamicId = summaryEntity.getId();
        //保存图片
        if (!CollectionUtils.isEmpty(reqVo.getPictureReqVos())) {
            reqVo.getPictureReqVos().forEach(o -> {
                SfaWorkSummaryPictureEntity pictureEntity = CrmBeanUtil.copy(o, SfaWorkSummaryPictureEntity.class);
                pictureEntity.setBusinessId(dynamicId);
                sfaWorkSummaryPictureMapper.insert(pictureEntity);
            });
        }
        //保存@人员信息账号
        Map<String, SfaWorkSummaryScopeEntity> scopeEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(reqVo.getAtColleagueCode())) {
            reqVo.getAtColleagueCode().forEach(o -> {
                SfaWorkSummaryAtLogEntity atLogEntity = new SfaWorkSummaryAtLogEntity();
                atLogEntity.setAtUserCode(o);
                if (SfaWorkSummaryEnum.IsForward.Y.getVal().equals(reqVo.getIsForward())) {
                    atLogEntity.setSummaryId(reqVo.getSummaryId());
                } else {
                    atLogEntity.setSummaryId(dynamicId);
                }
                atLogEntity.setBusinessId(dynamicId);
                sfaWorkSummaryAtLogMapper.insert(atLogEntity);
                //@人员也具有查看动态权限所以把@人员也保存进范围信息中
                SfaWorkSummaryScopeEntity scopeEntity = new SfaWorkSummaryScopeEntity();
                scopeEntity.setBusinessId(dynamicId);
                scopeEntity.setScopeCode(o);
                scopeEntity.setScopeCount(1);
                scopeEntity.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
                sfaWorkSummaryScopeMapper.insert(scopeEntity);
                scopeEntityMap.put(o, scopeEntity);
            });
        }
        //保存范围信息
        SfaWorkSummaryEnum.ScopeType scopeType = SfaWorkSummaryEnum.ScopeType.valueOf(reqVo.getScopeType());
        if (!SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal().equals(scopeType.getVal())) {
            SfaWorkSummaryScopeEntity scopeEntity = new SfaWorkSummaryScopeEntity();
            scopeEntity.setBusinessId(dynamicId);
            scopeEntity.setScopeCount(1);
            scopeEntity.setScopeType(scopeType.getVal());
            switch (scopeType) {
                case ALL:
                    scopeEntity.setScopeCode(scopeType.getVal());
                    break;
                case SELF_SUPERIORS:
                    scopeEntity.setScopeCode(summaryEntity.getCreatePosCode());
                    break;
                case ORG_SUBORDINATE:
                    scopeEntity.setScopeCode(summaryEntity.getCreateOrgCode());
                    break;
                default:
            }
            sfaWorkSummaryScopeMapper.insert(scopeEntity);
        } else {
            //自定义范围（保存的是用户账号）
            reqVo.getScopeColleagueCode().forEach(o -> {
                SfaWorkSummaryScopeEntity scopeEntity = scopeEntityMap.get(o);
                if (!ObjectUtils.isEmpty(scopeEntity)) {
                    scopeEntity.setScopeCount(scopeEntity.getScopeCount() + 1);
                    sfaWorkSummaryScopeMapper.updateById(scopeEntity);
                } else {
                    scopeEntity = new SfaWorkSummaryScopeEntity();
                    scopeEntity.setBusinessId(dynamicId);
                    scopeEntity.setScopeCode(o);
                    scopeEntity.setScopeCount(1);
                    scopeEntity.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
                    sfaWorkSummaryScopeMapper.insert(scopeEntity);
                }
            });
        }
        //为自己创建权限
        SfaWorkSummaryScopeEntity currScope = scopeEntityMap.get(user.getUsername());
        if (!ObjectUtils.isEmpty(currScope)) {
            currScope.setScopeCount(currScope.getScopeCount() + 1);
            sfaWorkSummaryScopeMapper.updateById(currScope);
        } else {
            currScope = new SfaWorkSummaryScopeEntity();
            currScope.setBusinessId(dynamicId);
            currScope.setScopeCode(user.getUsername());
            currScope.setScopeCount(1);
            currScope.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
            sfaWorkSummaryScopeMapper.insert(currScope);
        }
    }

    /**
     * 数据校验
     *
     * @param reqVo
     */
    private void validation(SfaWorkSummaryPrimaryReqVo reqVo) {
        ValidateUtils.validate(reqVo.getIsForward(), "是否转发（Y/N）标示不能为空");
        String isForward = SfaWorkSummaryEnum.IsForward.GETMAP.get(reqVo.getIsForward());
        ValidateUtils.validate(isForward, "是否转发（Y/N）标示错误");
        ValidateUtils.validate(reqVo.getScopeType(), "可见范围类型不能为空");
        String scopeType = SfaWorkSummaryEnum.ScopeType.GETMAP.get(reqVo.getScopeType());
        ValidateUtils.validate(scopeType, "可见范围类型错误");
        //自定义权限需要选择人员
        if (SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal().equals(reqVo.getScopeType())) {
            ValidateUtils.notEmpty(reqVo.getScopeColleagueCode(), "自定义权限类型需要指定人员");
        }
        if (SfaWorkSummaryEnum.IsForward.N.getVal().equals(reqVo.getIsForward())) {
            String lectureType = reqVo.getLectureType();
            ValidateUtils.validate(lectureType, "总结类型不能为空");
            String lectureTypeStr = SfaWorkSummaryEnum.LectureType.GETMAP.get(lectureType);
            ValidateUtils.validate(lectureTypeStr, "总结类型错误");
            //日报，周报，月报 要保证唯一
            if (SfaWorkSummaryEnum.LectureType.DAILY.getVal().equals(lectureType)
                    || SfaWorkSummaryEnum.LectureType.WEEKLY.getVal().equals(lectureType)
                    || SfaWorkSummaryEnum.LectureType.MONTHLY.getVal().equals(lectureType)) {
                SfaWorkSummaryPrimaryRespVo primaryRespVo = sfaWorkSummaryPrimaryMapper.findByOnlyOne(reqVo);
                //!ObjectUtils.isEmpty(primaryRespVo)
                if (!ObjectUtils.isEmpty(primaryRespVo)) {
                    //当前登录人信息
                    UserRedis user = UserUtils.getUser();
                    //当前时间
                    String formatDate = DateUtil.formatDate();
                    //最新数据创建时间
                    String createDate = primaryRespVo.getCreateDate();
                    SfaWorkSummaryEnum.LectureType type = SfaWorkSummaryEnum.LectureType.valueOf(lectureType);
                    //提示
                    String errorMsg = "";
                    switch (type) {
                        case DAILY:
                            if (createDate.compareTo(formatDate) >= 0) {
                                errorMsg = "本日已提交工作日报";
                            }
                            break;
                        case WEEKLY:
                            //计算日期相差天数
                            SimpleDateFormat sdfw = new SimpleDateFormat("yyyy-MM-dd");
                            try {
                                Date formatMonth = sdfw.parse(formatDate);
                                Date createMonth = sdfw.parse(createDate);
                                Date firstDayOfWeekByFormatMonth = DateUtil.getFirstDayOfWeek(formatMonth);
                                Date firstDayOfWeekByCreateMonth = DateUtil.getFirstDayOfWeek(createMonth);
                                if (firstDayOfWeekByFormatMonth.compareTo(firstDayOfWeekByCreateMonth) == 0) {
                                    errorMsg = "本周已提交工作周报";
                                }
                            } catch (Exception e) {
                                log.error("日期处理异常", e);
                            }
                            break;
                        case MONTHLY:
                            SimpleDateFormat sdfm = new SimpleDateFormat("yyyy-MM");
                            try {
                                Date formatMonth = sdfm.parse(formatDate);
                                Date createMonth = sdfm.parse(createDate);
                                if (createMonth.compareTo(formatMonth) >= 0) {
                                    errorMsg = "本月已提交工作月报";
                                }
                            } catch (Exception e) {
                                log.error("日期处理异常", e);
                            }
                            break;
                        default:
                    }
                    if (!StringUtils.isEmpty(errorMsg)) {
                        throw new BusinessException(errorMsg);
                    }
                }
            }
        }
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSummaryPrimaryReqVo reqVo) {
        SfaWorkSummaryPrimaryEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        List<SfaWorkSummaryPrimaryEntity> sfaWorkSummaryEntities = sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty(sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        //设置状态为启用
        List<SfaWorkSummaryPrimaryEntity> sfaWorkSummaryEntities = sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty(sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        //设置状态为禁用
        List<SfaWorkSummaryPrimaryEntity> sfaWorkSummaryEntities = sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty(sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    /**
     * 查询转发列表
     *
     * @param params
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryPrimaryRespVo> forwradList(SfaWorkSummaryPrimaryReqVo params) {
        Page<SfaWorkSummaryPrimaryRespVo> page = new Page<>(params.getPageNum(), params.getPageSize());
        List<SfaWorkSummaryPrimaryRespVo> list = sfaWorkSummaryPrimaryMapper.forwradList(page, params);
        //数据处理
        if (!CollectionUtils.isEmpty(list)) {
            //创建人
            Set<String> createCodes = Sets.newHashSet();
            //数据ID
            List<String> ids = Lists.newArrayList();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
                ids.add(o.getId());
            });

            //查询@人信息
            List<SfaWorkSummaryAtLogRespVo> atLogRespVos = sfaWorkSummaryAtLogMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap = atLogRespVos.stream()
                    .collect(Collectors.groupingBy(SfaWorkSummaryAtLogRespVo::getBusinessId));
            atLogRespVoMap.forEach((k, v) -> {
                v.forEach(o -> {
                    createCodes.add(o.getAtUserCode());
                });
            });
            //查询人员信息
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            //userQueryVo.setPrimaryFlag("0");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List<MdmPositionUserOrgRespVo> userOrgRespVos = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map<String, MdmPositionUserOrgRespVo> userOrgRespVoMap = userOrgRespVos.stream()
                    .collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity(), (mdmPositionUserOrgRespVo, mdmPositionUserOrgRespVo2) -> mdmPositionUserOrgRespVo2));
            list.forEach(o -> {
                //头像
                MdmPositionUserOrgRespVo userOrgRespVo = userOrgRespVoMap.get(o.getCreateCode());
                o.setPhoto(userOrgRespVo.getUserHeadUrl());
                //@人员
                List<SfaWorkSummaryAtLogRespVo> atLogArray = atLogRespVoMap.get(o.getId());
                if (!CollectionUtils.isEmpty(atLogArray)) {
                    atLogArray.forEach(e -> {
                        MdmPositionUserOrgRespVo userRespVo = userOrgRespVoMap.get(e.getAtUserCode());
                        e.setAtUserName(userRespVo.getFullName());
                    });
                    o.setAtLogRespVos(atLogArray);
                }
            });

        }
        return PageResult.<SfaWorkSummaryPrimaryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
}
