package com.biz.crm.worksummary.service.impl;

import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksummary.model.SfaWorkSummaryScopeEntity;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryScopeMapper;
import com.biz.crm.worksummary.service.ISfaWorkSummaryScopeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryScopeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryScopeReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 工作总结可见权限接口实现
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaWorkSummaryScopeServiceExpandImpl")
public class SfaWorkSummaryScopeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaWorkSummaryScopeMapper, SfaWorkSummaryScopeEntity> implements ISfaWorkSummaryScopeService {

    @Resource
    private SfaWorkSummaryScopeMapper sfaWorkSummaryScopeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryScopeRespVo> findList(SfaWorkSummaryScopeReqVo reqVo){
        Page<SfaWorkSummaryScopeRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSummaryScopeRespVo> list = sfaWorkSummaryScopeMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSummaryScopeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSummaryScopeRespVo
     */
    @Override
    public SfaWorkSummaryScopeRespVo query(SfaWorkSummaryScopeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSummaryScopeReqVo reqVo){
        SfaWorkSummaryScopeEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSummaryScopeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSummaryScopeReqVo reqVo){
        SfaWorkSummaryScopeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSummaryScopeReqVo reqVo){
        List<SfaWorkSummaryScopeEntity> sfaWorkSummaryScopeEntities = sfaWorkSummaryScopeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryScopeEntities)){
            sfaWorkSummaryScopeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryScopeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSummaryScopeReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSummaryScopeEntity> sfaWorkSummaryScopeEntities = sfaWorkSummaryScopeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryScopeEntities)){
            sfaWorkSummaryScopeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryScopeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSummaryScopeReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSummaryScopeEntity> sfaWorkSummaryScopeEntities = sfaWorkSummaryScopeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryScopeEntities)){
                sfaWorkSummaryScopeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryScopeEntities);
    }
}
