/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignConfigMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignConfigEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignRecordServiceExpandImpl"})
public class SfaWorkSignRecordServiceImpl
extends ServiceImpl<SfaWorkSignRecordMapper, SfaWorkSignRecordEntity>
implements ISfaWorkSignRecordService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRecordServiceImpl.class);
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private SfaWorkSignPlaceMapper sfaWorkSignPlaceMapper;
    @Resource
    private SfaFreesignConfigMapper sfaFreesignConfigMapper;
    @Resource
    private SfaFreesignSignTypeMapper sfaFreesignSignTypeMapper;
    @Autowired
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Autowired
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Autowired
    private ISfaFreesignConfigService sfaFreesignConfigService;
    @Autowired
    private ISfaFreesignSignTypeService sfaFreesignSignTypeService;

    @Override
    public PageResult<SfaWorkSignRecordRespVo> findList(SfaWorkSignRecordReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRecordRespVo> list = this.sfaWorkSignRecordMapper.findList((Page<SfaWorkSignRecordRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRecordRespVo query(SfaWorkSignRecordReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRecordEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result gotoWorkClockIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)sfaWorkSignRecordReqVo.getId())));
        if (null == sfaWorkSignRecord) {
            result.error500("\u65e0\u5bf9\u5e94\u7684\u8003\u52e4\u89c4\u5219");
            return result;
        }
        if (!SfaWorkSignEnum.workSignState.S0.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())) {
            result.error500("\u4e0a\u73ed\u4ee5\u7b7e\u5230,\u4e0d\u80fd\u91cd\u590d\u7b7e\u5230!");
            return result;
        }
        Date currentTime = new Date();
        String workSignTime = DateUtil.short_time_sdf.format(new Date());
        if (StringUtil.isEmpty((String)sfaWorkSignRecord.getWsRuleInfoId())) {
            result.error500("\u65e0\u5bf9\u5e94\u7684\u8003\u52e4\u89c4\u5219");
            return result;
        }
        SfaWorkSignRuleInfoEntity workSignRuleInfo = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoService.getById((Serializable)((Object)sfaWorkSignRecord.getWsRuleInfoId())));
        if (null == workSignRuleInfo) {
            result.error500("\u65e0\u5bf9\u5e94\u7684\u8003\u52e4\u89c4\u5219");
            return result;
        }
        String gooffWork = workSignRuleInfo.getGooffWork();
        if (SfaWorkSignEnum.gooffWorkEnum.Three.equals((Object)gooffWork)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5\u65e0\u9700\u4e0a\u73ed\u6253\u5361!");
            return result;
        }
        String ruleDate = workSignRuleInfo.getRuleDate();
        try {
            Date gotoStartTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGotoStartTime());
            Date gotoEndTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGotoEndTime());
            if (gotoStartTime.getTime() > currentTime.getTime() || gotoEndTime.getTime() < currentTime.getTime()) {
                result.error500("\u672a\u5230\u4e0a\u73ed\u7b7e\u5230\u65f6\u95f4\uff0c\u6216\u4e0a\u73ed\u7b7e\u5230\u65f6\u95f4\u5df2\u8fc7!");
                return result;
            }
            Date gotoTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGotoTime());
            if (gotoTime.getTime() > currentTime.getTime()) {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.workSignState.S2.getVal());
            } else {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.workSignState.S1.getVal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sfaWorkSignRecord.setWorkSignType(SfaWorkSignEnum.WorkSignType.R1.getVal());
        sfaWorkSignRecord.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.R1.getDesc());
        sfaWorkSignRecord.setWorkSignTime(workSignTime);
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getWorkSignPlace())) {
            result.error500("\u8003\u52e4\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLngIn())) {
            result.error500("\u7b7e\u5230\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLatIn())) {
            result.error500("\u7b7e\u5230\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        sfaWorkSignRecord.setWorkSignPlace(sfaWorkSignRecordReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLngIn());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLatIn());
        sfaWorkSignRecordReqVo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.P1.getVal());
        LambdaQueryWrapper placeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignPlaceEntity::getRuleCode, (Object)workSignRuleInfo.getId())).eq(SfaWorkSignPlaceEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R1.getVal());
        List workSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectList((Wrapper)placeWrapper);
        String electronFence = workSignRuleInfo.getElectronFence();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)workSignPlaceEntities) && !SfaWorkSignEnum.electronFenceEnum.F2.getVal().equals(electronFence)) {
            Boolean isPlace = false;
            for (SfaWorkSignPlaceEntity workSignPlace : workSignPlaceEntities) {
                String placeLngin = workSignPlace.getPlaceLngin();
                String placeLatin = workSignPlace.getPlaceLatin();
                String placeRange = workSignPlace.getPlaceRange();
                double placeRanged = Double.valueOf(placeRange.trim());
                double wsDistance = DistanceUtil.GetPointDistance((String)(sfaWorkSignRecordReqVo.getLatIn() + "," + sfaWorkSignRecordReqVo.getLngIn()), (String)(placeLatin + "," + placeLngin));
                if (!(wsDistance <= placeRanged)) continue;
                isPlace = true;
                break;
            }
            if (SfaWorkSignEnum.electronFenceEnum.F3.getVal().equals(electronFence) && !isPlace.booleanValue()) {
                result.error500("\u4e0d\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361");
                return result;
            }
            if (SfaWorkSignEnum.electronFenceEnum.F1.getVal().equals(electronFence) && !isPlace.booleanValue()) {
                sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.P2.getVal());
            }
        }
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos())) {
            result.error500("\u7b7e\u5230\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        sfaWorkSignRecord.setRemarks(sfaWorkSignRecordReqVo.getRemarks());
        this.updateById((Object)sfaWorkSignRecord);
        List workSignPictureEntityList = sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = new SfaWorkSignPictureEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)workSignPictureEntity));
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        this.sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok((Object)((Object)sfaWorkSignRecord));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result gooffWorkSignOut(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        LambdaQueryWrapper recordWrapperR1;
        List recordWrapperR1List;
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)sfaWorkSignRecordReqVo.getId())));
        if (null == sfaWorkSignRecord) {
            result.error500("\u4e0b\u73ed\u65e0\u9700\u7b7e\u9000");
            return result;
        }
        if (!SfaWorkSignEnum.workSignState.S0.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())) {
            result.error500("\u4e0b\u73ed\u4ee5\u7b7e\u9000,\u4e0d\u80fd\u91cd\u590d\u7b7e\u9000!");
            return result;
        }
        Date currentTime = new Date();
        String workSignTime = DateUtil.short_time_sdf.format(currentTime);
        if (StringUtil.isEmpty((String)sfaWorkSignRecord.getWsRuleInfoId())) {
            result.error500("\u65e0\u5bf9\u5e94\u7684\u8003\u52e4\u89c4\u5219");
            return result;
        }
        SfaWorkSignRuleInfoEntity workSignRuleInfo = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoService.getById((Serializable)((Object)sfaWorkSignRecord.getWsRuleInfoId())));
        if (null == workSignRuleInfo) {
            result.error500("\u65e0\u5bf9\u5e94\u7684\u8003\u52e4\u89c4\u5219");
            return result;
        }
        String gooffWork = workSignRuleInfo.getGooffWork();
        if (SfaWorkSignEnum.gooffWorkEnum.One.equals((Object)gooffWork)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5,\u65e0\u9700\u4e0b\u73ed\u7b7e\u9000!");
            return result;
        }
        if (SfaWorkSignEnum.gooffWorkEnum.Two.equals((Object)gooffWork) && (CollectionUtil.listNotEmptyNotSizeZero((List)(recordWrapperR1List = this.sfaWorkSignRecordMapper.selectList((Wrapper)(recordWrapperR1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfo.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R1.getVal()))))) || SfaWorkSignEnum.workSignState.S0.getVal().equals(((SfaWorkSignRecordEntity)((Object)recordWrapperR1List.get(0))).getWorkSignStatus()))) {
            result.error500("\u4e0a\u73ed\u672a\u7b7e\u5230,\u4e0d\u80fd\u505a\u4e0b\u73ed\u7b7e\u9000!");
            return result;
        }
        String ruleDate = workSignRuleInfo.getRuleDate();
        try {
            Date gooffStartTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGooffStartTime());
            Date gooffEndTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGooffEndTime());
            if (gooffStartTime.getTime() > currentTime.getTime() || gooffEndTime.getTime() < currentTime.getTime()) {
                result.error500("\u672a\u5230\u4e0b\u73ed\u7b7e\u9000\u65f6\u95f4\uff0c\u6216\u4e0b\u73ed\u7b7e\u9000\u65f6\u95f4\u5df2\u8fc7!");
                return result;
            }
            Date gooffTime = DateUtil.datetimeFormat.parse(ruleDate + " " + workSignRuleInfo.getGooffTime());
            if (gooffTime.getTime() > currentTime.getTime()) {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.workSignState.S3.getVal());
            } else {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.workSignState.S1.getVal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sfaWorkSignRecord.setWorkSignType(SfaWorkSignEnum.WorkSignType.R2.getVal());
        sfaWorkSignRecord.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.R2.getDesc());
        sfaWorkSignRecord.setWorkSignTime(workSignTime);
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getWorkSignPlace())) {
            result.error500("\u8003\u52e4\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLngIn())) {
            result.error500("\u7b7e\u9000\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLatIn())) {
            result.error500("\u7b7e\u9000\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        sfaWorkSignRecord.setWorkSignPlace(sfaWorkSignRecordReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLngIn());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLatIn());
        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.P1.getVal());
        LambdaQueryWrapper placeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignPlaceEntity::getRuleCode, (Object)workSignRuleInfo.getId())).eq(SfaWorkSignPlaceEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R2.getVal());
        List workSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectList((Wrapper)placeWrapper);
        String electronFence = workSignRuleInfo.getElectronFence();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)workSignPlaceEntities) && !SfaWorkSignEnum.electronFenceEnum.F2.getVal().equals(electronFence)) {
            Boolean isPlace = false;
            for (SfaWorkSignPlaceEntity workSignPlace : workSignPlaceEntities) {
                String placeLngin = workSignPlace.getPlaceLngin();
                String placeLatin = workSignPlace.getPlaceLatin();
                String placeRange = workSignPlace.getPlaceRange();
                double placeRanged = Double.valueOf(placeRange.trim());
                double wsDistance = DistanceUtil.GetPointDistance((String)(sfaWorkSignRecordReqVo.getLatIn() + "," + sfaWorkSignRecordReqVo.getLngIn()), (String)(placeLatin + "," + placeLngin));
                if (!(wsDistance <= placeRanged)) continue;
                isPlace = true;
                break;
            }
            if (SfaWorkSignEnum.electronFenceEnum.F3.getVal().equals(electronFence) && !isPlace.booleanValue()) {
                result.error500("\u4e0d\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361");
                return result;
            }
            if (SfaWorkSignEnum.electronFenceEnum.F1.getVal().equals(electronFence) && !isPlace.booleanValue()) {
                sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.P2.getVal());
            }
        }
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos())) {
            result.error500("\u7b7e\u9000\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        sfaWorkSignRecord.setRemarks(sfaWorkSignRecordReqVo.getRemarks());
        this.updateById((Object)sfaWorkSignRecord);
        List workSignPictureEntityList = sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = new SfaWorkSignPictureEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)workSignPictureEntity));
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        this.sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok((Object)((Object)sfaWorkSignRecord));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goFreeSignIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        Result result = new Result();
        Date currentTime = new Date();
        String currentDateStr = DateUtil.date_sdf.format(currentTime);
        String workSignTime = DateUtil.short_time_sdf.format(currentTime);
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getFreesignCode())) {
            result.error500("\u8bf7\u9009\u62e9\u5bf9\u5e94\u7b7e\u5230\u7ec4");
            return result;
        }
        LambdaQueryWrapper freesignWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaFreesignConfigEntity::getFreesignCode, (Object)sfaWorkSignRecordReqVo.getFreesignCode());
        List freesignConfigList = this.sfaFreesignConfigMapper.selectList((Wrapper)freesignWrapper);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)freesignConfigList)) {
            result.error500("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7b7e\u5230\u7ec4");
            return result;
        }
        SfaFreesignConfigEntity freesignConfigEntity = (SfaFreesignConfigEntity)((Object)freesignConfigList.get(0));
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getSignTypeCode())) {
            result.error500("\u8bf7\u9009\u62e9\u5bf9\u5e94\u6253\u5361\u7c7b\u578b");
            return result;
        }
        LambdaQueryWrapper signTypeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaFreesignSignTypeEntity::getSignTypeCode, (Object)sfaWorkSignRecordReqVo.getSignTypeCode());
        List freesignSignTypeList = this.sfaFreesignSignTypeMapper.selectList((Wrapper)signTypeWrapper);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)freesignSignTypeList)) {
            result.error500("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6253\u5361\u7c7b\u578b");
            return result;
        }
        SfaFreesignSignTypeEntity freesignSignTypeEntity = (SfaFreesignSignTypeEntity)((Object)freesignSignTypeList.get(0));
        if (StringUtil.isEmpty((String)freesignSignTypeEntity.getTimeReq()) && SfaCommonEnum.YesNoEnum.ONE.equals((Object)freesignSignTypeEntity.getTimeReq())) {
            try {
                Date beginDate = DateUtil.datetimeFormat.parse(currentDateStr + " " + freesignSignTypeEntity.getBeginDate());
                Date endDate = DateUtil.datetimeFormat.parse(currentDateStr + " " + freesignSignTypeEntity.getEndDate());
                if (currentTime.getTime() < beginDate.getTime()) {
                    result.error500("\u5f53\u524d\u65f6\u95f4\u672a\u5230,\u8be5\u7b7e\u5230\u7ec4\u3010" + freesignConfigEntity.getFreesignName() + "\u3011\u6253\u5361\u7c7b\u578b\u3010" + freesignSignTypeEntity.getSignTypeName() + "\u3011\u7684\u6253\u5361\u65f6\u95f4");
                    return result;
                }
                if (currentTime.getTime() > endDate.getTime()) {
                    result.error500("\u5f53\u524d\u65f6\u95f4\u8d85\u8fc7,\u8be5\u7b7e\u5230\u7ec4\u3010" + freesignConfigEntity.getFreesignName() + "\u3011\u6253\u5361\u7c7b\u578b\u3010" + freesignSignTypeEntity.getSignTypeName() + "\u3011\u7684\u6253\u5361\u65f6\u95f4");
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtil.isEmpty((String)freesignSignTypeEntity.getPhotoReq()) && SfaCommonEnum.YesNoEnum.ONE.equals((Object)freesignSignTypeEntity.getPhotoReq()) && CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos())) {
            result.error500("\u6253\u5361\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getWorkSignPlace())) {
            result.error500("\u8003\u52e4\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLngIn())) {
            result.error500("\u7b7e\u9000\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        if (StringUtil.isEmpty((String)sfaWorkSignRecordReqVo.getLatIn())) {
            result.error500("\u7b7e\u9000\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        SfaWorkSignRuleInfoEntity workSignRuleInfo = new SfaWorkSignRuleInfoEntity();
        workSignRuleInfo.setUserName(userRedis.getUsername());
        workSignRuleInfo.setRealName(userRedis.getRealname());
        workSignRuleInfo.setPosCode(userRedis.getPoscode());
        workSignRuleInfo.setPosName(userRedis.getPosname());
        workSignRuleInfo.setOrgCode(userRedis.getOrgcode());
        workSignRuleInfo.setOrgName(userRedis.getOrgname());
        workSignRuleInfo.setRuleCode(freesignConfigEntity.getFreesignCode());
        workSignRuleInfo.setRuleName(freesignConfigEntity.getFreesignName());
        workSignRuleInfo.setRuleType(SfaWorkSignEnum.WorkSignRuleType.R0.getVal());
        workSignRuleInfo.setRuleType(currentDateStr);
        if (StringUtil.isNotEmpty((String)freesignSignTypeEntity.getBeginDate())) {
            workSignRuleInfo.setGotoStartTime(freesignSignTypeEntity.getBeginDate());
        }
        if (StringUtil.isNotEmpty((String)freesignSignTypeEntity.getEndDate())) {
            workSignRuleInfo.setGotoEndTime(freesignSignTypeEntity.getEndDate());
        }
        workSignRuleInfo.setElectronFence(SfaWorkSignEnum.electronFenceEnum.F2.getVal());
        SfaWorkSignRecordEntity sfaWorkSignRecord = new SfaWorkSignRecordEntity();
        sfaWorkSignRecord.setWorkSignType(freesignSignTypeEntity.getSignTypeCode());
        sfaWorkSignRecord.setWorkSignDesc(freesignSignTypeEntity.getSignTypeName());
        sfaWorkSignRecord.setWorkSignTime(workSignTime);
        sfaWorkSignRecord.setWorkSignPlace(sfaWorkSignRecordReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLngIn());
        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLatIn());
        sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.workSignState.S1.getVal());
        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.P1.getVal());
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
        sfaWorkSignRecord.setRemarks(sfaWorkSignRecordReqVo.getRemarks());
        this.sfaWorkSignRuleInfoService.save((Object)workSignRuleInfo);
        sfaWorkSignRecord.setWsRuleInfoId(workSignRuleInfo.getId());
        this.save((Object)sfaWorkSignRecord);
        List workSignPictureEntityList = sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = new SfaWorkSignPictureEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)workSignPictureEntity));
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        this.sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok((Object)((Object)sfaWorkSignRecord));
    }
}

