/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.mapper.SfaVisitRoleConfigMapper;
import com.biz.crm.collection.mapper.SfaVisitRoleDirectoryMapper;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.collection.service.ISfaVisitRoleConfigService;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitRoleConfigServiceExpandImpl"})
public class SfaVisitRoleConfigServiceImpl
extends ServiceImpl<SfaVisitRoleConfigMapper, SfaVisitRoleConfigEntity>
implements ISfaVisitRoleConfigService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitRoleConfigServiceImpl.class);
    @Resource
    private SfaVisitRoleConfigMapper sfaVisitRoleConfigMapper;
    @Resource
    private SfaVisitRoleDirectoryMapper sfaVisitRoleDirectoryMapper;
    @Autowired
    private ISfaVisitRoleDirectoryService iSfaVisitRoleDirectoryService;

    @Override
    public PageResult<SfaVisitRoleConfigRespVo> findList(SfaVisitRoleConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitRoleConfigRespVo> list = this.sfaVisitRoleConfigMapper.findList((Page<SfaVisitRoleConfigRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List visitRoleCodes = list.stream().map(UuidVo::getId).collect(Collectors.toList());
            SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
            visitRoleDirectoryReqVo.setVisitRoleCodes(visitRoleCodes);
            visitRoleDirectoryReqVo.setPageSize(Integer.valueOf(-1));
            List visitRoleDirectoryRespVos = this.iSfaVisitRoleDirectoryService.findList(visitRoleDirectoryReqVo).getData();
            Map<String, List<SfaVisitRoleDirectoryRespVo>> visitRoleDirectoryRespMap = visitRoleDirectoryRespVos.stream().collect(Collectors.groupingBy(SfaVisitRoleDirectoryRespVo::getVisitRoleCode));
            for (SfaVisitRoleConfigRespVo visitRoleConfigRespVo : list) {
                List<SfaVisitRoleDirectoryRespVo> voList = visitRoleDirectoryRespMap.get(visitRoleConfigRespVo.getId());
                if (voList == null || voList.size() <= 0) continue;
                StringBuffer buffer = new StringBuffer();
                for (SfaVisitRoleDirectoryRespVo roleDirectoryRespVo : voList) {
                    if (buffer.length() > 0) {
                        buffer.append("\u3001");
                    }
                    buffer.append(roleDirectoryRespVo.getDirectoryName());
                }
                visitRoleConfigRespVo.setDirectoryDescs(buffer.toString());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitRoleConfigRespVo query(SfaVisitRoleConfigReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
            return new SfaVisitRoleConfigRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitRoleConfigRespVo();
        }
        SfaVisitRoleConfigRespVo respVo = (SfaVisitRoleConfigRespVo)list.get(0);
        SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
        visitRoleDirectoryReqVo.setVisitRoleCode(respVo.getVisitRoleCode());
        List visitRoleDirectoryRespVos = this.iSfaVisitRoleDirectoryService.findList(visitRoleDirectoryReqVo).getData();
        respVo.setVisitRoleDirectoryRespVos(visitRoleDirectoryRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitRoleConfigReqVo reqVo) {
        this.saveCheck(reqVo);
        for (SfaVisitRoleReqVo visitRoleReqVo : reqVo.getVisitRoleReqVos()) {
            SfaVisitRoleConfigEntity entity = (SfaVisitRoleConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitRoleConfigEntity.class));
            String code = CodeUtil.createCode();
            entity.setVisitRoleCode(code);
            entity.setRoleCode(visitRoleReqVo.getRoleCode());
            entity.setRoleName(visitRoleReqVo.getRoleName());
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.save((Object)entity);
            this.saveData(reqVo.getVisitRoleDirectoryReqVos(), entity);
        }
    }

    private void saveCheck(SfaVisitRoleConfigReqVo reqVo) {
        if (CollectionUtil.listEmpty((List)reqVo.getVisitRoleReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u89d2\u8272.");
        }
        for (SfaVisitRoleReqVo visitRoleReqVo : reqVo.getVisitRoleReqVos()) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaVisitRoleConfigEntity::getRoleCode, (Object)visitRoleReqVo.getRoleCode());
            if (StringUtils.isNotEmpty((String)reqVo.getId())) {
                wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
            }
            SfaVisitRoleConfigEntity entity = (SfaVisitRoleConfigEntity)((Object)this.sfaVisitRoleConfigMapper.selectOne((Wrapper)wrapper));
            AssertUtils.isNotNull((Object)((Object)entity), (String)("\u89d2\u8272:" + visitRoleReqVo.getRoleCode() + "|" + visitRoleReqVo.getRoleName() + "\uff0c\u5df2\u5b58\u5728\u6b65\u9aa4\u914d\u7f6e,\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitType(), (String)"\u8bf7\u9009\u62e9\u62dc\u8bbf\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getSfacusType(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u7c7b\u578b");
        if (CollectionUtil.listEmpty((List)reqVo.getVisitRoleDirectoryReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u62dc\u8bbf\u6b65\u9aa4.");
        }
    }

    public void saveData(List<SfaVisitRoleDirectoryReqVo> visitRoleDirectoryReqVos, SfaVisitRoleConfigEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero(visitRoleDirectoryReqVos)) {
            List visitRoleDirectoryEntityList = visitRoleDirectoryReqVos.stream().map(o -> {
                SfaVisitRoleDirectoryEntity visitRoleDirectoryEntity = new SfaVisitRoleDirectoryEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)visitRoleDirectoryEntity));
                visitRoleDirectoryEntity.setVisitRoleCode(entity.getVisitRoleCode());
                return visitRoleDirectoryEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitRoleDirectoryService.saveBatch(visitRoleDirectoryEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitRoleConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitRoleConfigEntity entity = (SfaVisitRoleConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (CollectionUtil.listEmpty((List)reqVo.getVisitRoleDirectoryReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u62dc\u8bbf\u6b65\u9aa4.");
        }
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo.getVisitRoleDirectoryReqVos(), entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitRoleConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaVisitRoleConfigMapper.deleteProductsByParams(reqVo);
        List visitRoleCodes = list.stream().map(SfaVisitRoleConfigRespVo::getVisitRoleCode).collect(Collectors.toList());
        reqVo.setVisitRoleCodes(visitRoleCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitRoleConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitRoleCode()) && CollectionUtil.listEmpty((List)reqVo.getVisitRoleCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
        visitRoleDirectoryReqVo.setVisitRoleCode(reqVo.getVisitRoleCode());
        visitRoleDirectoryReqVo.setVisitRoleCodes(reqVo.getVisitRoleCodes());
        this.sfaVisitRoleDirectoryMapper.deleteProductsByParams(visitRoleDirectoryReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitRoleConfigReqVo reqVo) {
        List sfaVisitRoleConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitRoleConfigEntities = this.sfaVisitRoleConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitRoleConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitRoleConfigReqVo reqVo) {
        List sfaVisitRoleConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitRoleConfigEntities = this.sfaVisitRoleConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitRoleConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleConfigEntities);
    }
}

