/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitAssistInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAssistInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.mapper.SfaVisitAssistInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitAssistInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitAssistInfoService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitAssistInfoServiceExpandImpl"})
public class SfaVisitAssistInfoServiceImpl
extends ServiceImpl<SfaVisitAssistInfoMapper, SfaVisitAssistInfoEntity>
implements ISfaVisitAssistInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitAssistInfoServiceImpl.class);
    @Resource
    private SfaVisitAssistInfoMapper sfaVisitAssistInfoMapper;

    @Override
    public PageResult<SfaVisitAssistInfoRespVo> findList(SfaVisitAssistInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitAssistInfoRespVo> list = this.sfaVisitAssistInfoMapper.findList((Page<SfaVisitAssistInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitProgressRespVo visitProgress(SfaVisitAssistInfoReqVo sfaVisitAssistInfoReqVo) {
        SfaVisitProgressRespVo sfaVisitProgressRespVo = new SfaVisitProgressRespVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"visit_user_name", (Object)sfaVisitAssistInfoReqVo.getVisitUserName());
        queryWrapper.eq((Object)"visit_status", (Object)SfaVisitStatusEnum.PROCESSING.getCode());
        SfaVisitAssistInfoEntity sfaVisitPlanInfoEntity = (SfaVisitAssistInfoEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (sfaVisitPlanInfoEntity != null) {
            sfaVisitProgressRespVo.setInProgress(Boolean.valueOf(true));
            sfaVisitProgressRespVo.setClientId(sfaVisitPlanInfoEntity.getClientId());
            sfaVisitProgressRespVo.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
            sfaVisitProgressRespVo.setClientName(sfaVisitPlanInfoEntity.getClientName());
            sfaVisitProgressRespVo.setClientType(sfaVisitPlanInfoEntity.getClientType());
        }
        sfaVisitAssistInfoReqVo.setVisitStatus(SfaVisitStatusEnum.FINISHED.getCode());
        int rows = this.sfaVisitAssistInfoMapper.getCount(sfaVisitAssistInfoReqVo);
        sfaVisitProgressRespVo.setComplete(Integer.valueOf(rows));
        return sfaVisitProgressRespVo;
    }

    @Override
    public SfaVisitAssistInfoRespVo query(SfaVisitAssistInfoReqVo reqVo) {
        SfaVisitAssistInfoEntity sfaVisitAssistInfoEntity = (SfaVisitAssistInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        return (SfaVisitAssistInfoRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitAssistInfoEntity), SfaVisitAssistInfoRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitAssistInfoReqVo reqVo) {
        SfaVisitAssistInfoEntity entity = (SfaVisitAssistInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitAssistInfoEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitAssistInfoReqVo reqVo) {
        SfaVisitAssistInfoEntity entity = (SfaVisitAssistInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitAssistInfoReqVo reqVo) {
        List sfaVisitAssistInfoEntities = this.sfaVisitAssistInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitAssistInfoEntities)) {
            sfaVisitAssistInfoEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitAssistInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitAssistInfoReqVo reqVo) {
        List sfaVisitAssistInfoEntities = this.sfaVisitAssistInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitAssistInfoEntities)) {
            sfaVisitAssistInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitAssistInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitAssistInfoReqVo reqVo) {
        List sfaVisitAssistInfoEntities = this.sfaVisitAssistInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitAssistInfoEntities)) {
            sfaVisitAssistInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitAssistInfoEntities);
    }
}

