/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignTimeServiceExpandImpl"})
public class SfaWorkSignTimeServiceImpl
extends ServiceImpl<SfaWorkSignTimeMapper, SfaWorkSignTimeEntity>
implements ISfaWorkSignTimeService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignTimeServiceImpl.class);
    @Resource
    private SfaWorkSignTimeMapper sfaWorkSignTimeMapper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignTimeRespVo> findList(SfaWorkSignTimeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignTimeRespVo> list = this.sfaWorkSignTimeMapper.findList((Page<SfaWorkSignTimeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaWorkSignTimeRespVo query(SfaWorkSignTimeReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignTimeRespVo();
        }
        SfaWorkSignTimeRespVo sfaWorkSignTimeRespVo = (SfaWorkSignTimeRespVo)list.get(0);
        return sfaWorkSignTimeRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignTimeReqVo reqVo) {
        SfaWorkSignTimeEntity entity = (SfaWorkSignTimeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignTimeEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignTimeReqVo reqVo) {
        SfaWorkSignTimeEntity entity = (SfaWorkSignTimeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignTimeReqVo reqVo) {
        List sfaWorkSignTimeEntities = this.sfaWorkSignTimeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignTimeEntities)) {
            sfaWorkSignTimeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignTimeEntities);
    }

    @Override
    @CrmLog
    public void saveCheck(SfaWorkSignTimeReqVo timeReqVo) {
        SimpleDateFormat hms = new SimpleDateFormat("HH:mm:ss");
        AssertUtils.isNotEmpty((String)timeReqVo.getGotoTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gotoTime = null;
        try {
            gotoTime = hms.parse(timeReqVo.getGotoTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)timeReqVo.getGooffTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u4e0b\u73ed\u6253\u5361\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gooffTime = null;
        try {
            gooffTime = hms.parse(timeReqVo.getGooffTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0b\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (gotoTime.getTime() >= gooffTime.getTime()) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e0b\u73ed\u6253\u5361\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)timeReqVo.getGotoStartTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gotoStartTime = null;
        try {
            gotoStartTime = hms.parse(timeReqVo.getGotoStartTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)timeReqVo.getGotoEndTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gotoEndTime = null;
        try {
            gotoEndTime = hms.parse(timeReqVo.getGotoEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (gotoStartTime.getTime() >= gotoEndTime.getTime()) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)timeReqVo.getGooffStartTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gooffStartTime = null;
        try {
            gooffStartTime = hms.parse(timeReqVo.getGooffStartTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)timeReqVo.getGooffEndTime(), (String)"\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date gooffEndTime = null;
        try {
            gooffEndTime = hms.parse(timeReqVo.getGooffEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (gooffStartTime.getTime() >= gooffEndTime.getTime()) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0b\u73ed\u5361\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (gotoEndTime.getTime() >= gooffStartTime.getTime()) {
            throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u6253\u5361\u65f6\u95f4\u9650\u5236-\u53ef\u6253\u4e0a\u73ed\u5361\u7ed3\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u53ef\u6253\u4e0b\u73ed\u5361\u5f00\u59cb\u65f6\u95f4");
        }
    }
}

