/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPersonnelMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignRuleMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignSpecialMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignPlaceService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignRuleServiceExpandImpl"})
public class SfaWorkSignRuleServiceImpl
extends ServiceImpl<SfaWorkSignRuleMapper, SfaWorkSignRuleEntity>
implements ISfaWorkSignRuleService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleServiceImpl.class);
    @Autowired
    private ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService;
    @Autowired
    private ISfaWorkSignPlaceService iSfaWorkSignPlaceService;
    @Autowired
    private ISfaWorkSignTimeService iSfaWorkSignTimeService;
    @Autowired
    private ISfaWorkSignSpecialService iSfaWorkSignSpecialService;
    @Resource
    private SfaWorkSignRuleMapper sfaWorkSignRuleMapper;
    @Resource
    private SfaWorkSignPersonnelMapper personnelMapper;
    @Resource
    private SfaWorkSignPlaceMapper placeMapper;
    @Resource
    private SfaWorkSignSpecialMapper specialMapper;
    @Resource
    private SfaWorkSignTimeMapper signTimeMapper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignRuleRespVo> findList(SfaWorkSignRuleReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRuleRespVo> list = this.sfaWorkSignRuleMapper.findList((Page<SfaWorkSignRuleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaWorkSignRuleRespVo query(SfaWorkSignRuleReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignRuleRespVo();
        }
        SfaWorkSignRuleRespVo sfaWorkSignRuleRespVo = (SfaWorkSignRuleRespVo)list.get(0);
        SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
        sfaWorkSignPersonnelReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPersonnelReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignPersonnelRespVos = this.iSfaWorkSignPersonnelService.findList(sfaWorkSignPersonnelReqVo).getData();
        if (CollectionUtil.listEmpty((List)sfaWorkSignPersonnelRespVos)) {
            ArrayList<SfaWorkSignPersonnelRespVo> personnelRespContainVos = new ArrayList<SfaWorkSignPersonnelRespVo>();
            ArrayList<SfaWorkSignPersonnelRespVo> personnelRespNonInclusionVos = new ArrayList<SfaWorkSignPersonnelRespVo>();
            for (SfaWorkSignPersonnelRespVo personnelRespVo : sfaWorkSignPersonnelRespVos) {
                if (SfaCommonEnum.rangeTypeEnum.One.getVal().equals(personnelRespVo.getRangeType())) {
                    personnelRespContainVos.add(personnelRespVo);
                    continue;
                }
                personnelRespNonInclusionVos.add(personnelRespVo);
            }
            sfaWorkSignRuleRespVo.setPersonnelRespContainVos(personnelRespContainVos);
            sfaWorkSignRuleRespVo.setPersonnelRespNonInclusionVos(personnelRespNonInclusionVos);
        }
        SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo = new SfaWorkSignPlaceReqVo();
        sfaWorkSignPlaceReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPlaceReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignPlaceRespVos = this.iSfaWorkSignPlaceService.findList(sfaWorkSignPlaceReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignPlaceRespVos(sfaWorkSignPlaceRespVos);
        SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo = new SfaWorkSignTimeReqVo();
        sfaWorkSignTimeReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignTimeReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignTimeRespVos = this.iSfaWorkSignTimeService.findList(sfaWorkSignTimeReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignTimeRespVos(sfaWorkSignTimeRespVos);
        SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo = new SfaWorkSignSpecialReqVo();
        sfaWorkSignPersonnelReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        List<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialRespVos = this.iSfaWorkSignSpecialService.findNonPageList(sfaWorkSignSpecialReqVo);
        if (CollectionUtil.listEmpty(sfaWorkSignSpecialRespVos)) {
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialMustRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialNotRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            for (SfaWorkSignSpecialRespVo specialRespVos : sfaWorkSignSpecialRespVos) {
                if (SfaWorkSignEnum.workSignSpecialType.One.getVal().equals(specialRespVos.getWssType())) {
                    sfaWorkSignSpecialMustRespVos.add(specialRespVos);
                    continue;
                }
                sfaWorkSignSpecialNotRespVos.add(specialRespVos);
            }
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialMustRespVos(sfaWorkSignSpecialMustRespVos);
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialNotRespVos(sfaWorkSignSpecialNotRespVos);
        }
        return sfaWorkSignRuleRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignRuleReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleEntity.class));
        String code = CodeUtil.createCode();
        entity.setRuleCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaWorkSignRuleReqVo reqVo, SfaWorkSignRuleEntity entity) {
        ArrayList personnelEntityList = new ArrayList();
        if (CollectionUtil.listEmpty((List)reqVo.getPersonnelReqContainVos())) {
            List personnelContainList = reqVo.getPersonnelReqContainVos().stream().map(o -> {
                SfaWorkSignPersonnelEntity personnelEntity = new SfaWorkSignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setRuleCode(entity.getRuleCode());
                personnelEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.One.getVal());
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelContainList);
        }
        if (CollectionUtil.listEmpty((List)reqVo.getPersonnelReqNonInclusionVos())) {
            List personnelNonInclusionList = reqVo.getPersonnelReqNonInclusionVos().stream().map(o -> {
                SfaWorkSignPersonnelEntity personnelEntity = new SfaWorkSignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setRuleCode(entity.getRuleCode());
                personnelEntity.setRangeType(SfaCommonEnum.rangeTypeEnum.Two.getVal());
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelNonInclusionList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(personnelEntityList)) {
            this.iSfaWorkSignPersonnelService.saveBatch(personnelEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignPlaceReqVos())) {
            List signPlaceEntityList = reqVo.getSfaWorkSignPlaceReqVos().stream().map(o -> {
                SfaWorkSignPlaceEntity signPlaceEntity = new SfaWorkSignPlaceEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signPlaceEntity));
                signPlaceEntity.setRuleCode(entity.getRuleCode());
                return signPlaceEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignPlaceService.saveBatch(signPlaceEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignTimeReqVos())) {
            List signTimeEntityList = reqVo.getSfaWorkSignTimeReqVos().stream().map(o -> {
                SfaWorkSignTimeEntity signTimeEntity = new SfaWorkSignTimeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signTimeEntity));
                signTimeEntity.setRuleCode(entity.getRuleCode());
                return signTimeEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignTimeService.saveBatch(signTimeEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialMustReqVos())) {
            List signSpecialEntityList = reqVo.getSfaWorkSignSpecialMustReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity signSpecialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signSpecialEntity));
                signSpecialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.One.getVal());
                signSpecialEntity.setRuleCode(entity.getRuleCode());
                return signSpecialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveBatch(signSpecialEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialNotReqVos())) {
            List specialEntityList = reqVo.getSfaWorkSignSpecialNotReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity specialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)specialEntity));
                specialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.Two.getVal());
                specialEntity.setRuleCode(entity.getRuleCode());
                return specialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveBatch(specialEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        reqVo.setRuleCode(entity.getRuleCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    public void deleteBatchDate(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRuleCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRuleCodes())) {
            SfaWorkSignPersonnelReqVo signPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
            signPersonnelReqVo.setRuleCode(reqVo.getRuleCode());
            signPersonnelReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.personnelMapper.deleteProductsByParams(signPersonnelReqVo);
            SfaWorkSignPlaceReqVo signPlaceReqVo = new SfaWorkSignPlaceReqVo();
            signPlaceReqVo.setRuleCode(reqVo.getRuleCode());
            signPlaceReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.placeMapper.deleteProductsByParams(signPlaceReqVo);
            SfaWorkSignTimeReqVo signTimeReqVo = new SfaWorkSignTimeReqVo();
            signTimeReqVo.setRuleCode(reqVo.getRuleCode());
            signTimeReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.signTimeMapper.deleteProductsByParams(signTimeReqVo);
            SfaWorkSignSpecialReqVo signSpecialReqVo = new SfaWorkSignSpecialReqVo();
            signSpecialReqVo.setRuleCode(reqVo.getRuleCode());
            signSpecialReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.specialMapper.deleteProductsByParams(signSpecialReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaWorkSignRuleMapper.deleteProductsByParams(reqVo);
        List ruleCodes = list.stream().map(SfaWorkSignRuleRespVo::getRuleCode).collect(Collectors.toList());
        reqVo.setRuleCodes(ruleCodes);
        this.deleteBatchDate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())))) {
            sfaWorkSignRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())))) {
            sfaWorkSignRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
    }

    public void saveCheck(SfaWorkSignRuleReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getRuleName(), (String)"\u8bf7\u8f93\u5165\u89c4\u5219\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getRuleType(), (String)"\u8bf7\u8f93\u5165\u89c4\u5219\u7c7b\u578b");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPersonnelReqContainVos())) {
            for (SfaWorkSignPersonnelReqVo personnelReqContainVo : reqVo.getPersonnelReqContainVos()) {
                personnelReqContainVo.setRangeType(SfaCommonEnum.rangeTypeEnum.One.getVal());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPersonnelReqNonInclusionVos())) {
            for (SfaWorkSignPersonnelReqVo personnelReqNonInclusionVo : reqVo.getPersonnelReqNonInclusionVos()) {
                personnelReqNonInclusionVo.setRangeType(SfaCommonEnum.rangeTypeEnum.Two.getVal());
            }
        }
        if (CollectionUtil.listEmpty((List)reqVo.getSfaWorkSignPlaceReqVos())) {
            throw new BusinessException("\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u6253\u5361\u5730\u70b9");
        }
        int p = 1;
        for (SfaWorkSignPlaceReqVo placeReqVo : reqVo.getSfaWorkSignPlaceReqVos()) {
            AssertUtils.isNotEmpty((String)placeReqVo.getWspNo(), (String)("\u7b2c" + p + "\u6761\u6253\u5361\u5730\u70b9\uff0c\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.iSfaWorkSignPlaceService.saveCheck(placeReqVo);
            ++p;
        }
        AssertUtils.isNotEmpty((String)reqVo.getElectronFence(), (String)"\u8bf7\u9009\u62e9\u7535\u5b50\u56f4\u680f");
        if (CollectionUtil.listEmpty((List)reqVo.getSfaWorkSignTimeReqVos())) {
            throw new BusinessException("\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u6253\u5361\u65f6\u95f4");
        }
        int t = 1;
        SimpleDateFormat hms = new SimpleDateFormat("HH:mm:ss");
        for (SfaWorkSignTimeReqVo timeReqVo : reqVo.getSfaWorkSignTimeReqVos()) {
            try {
                this.iSfaWorkSignTimeService.saveCheck(timeReqVo);
            }
            catch (Exception e) {
                throw new BusinessException("\u7b2c" + t + "\u884c\u6253\u5361\u65f6\u95f4," + e.getMessage());
            }
            ++t;
        }
        t = 1;
        for (SfaWorkSignTimeReqVo timeReqVo : reqVo.getSfaWorkSignTimeReqVos()) {
            Date gotoTime = null;
            try {
                gotoTime = hms.parse(timeReqVo.getGotoTime());
            }
            catch (Exception e) {
                throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            Date gooffTime = null;
            try {
                gooffTime = hms.parse(timeReqVo.getGooffTime());
            }
            catch (Exception e) {
                throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0b\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            int i = 1;
            for (SfaWorkSignTimeReqVo timeReq : reqVo.getSfaWorkSignTimeReqVos()) {
                if (t == i) continue;
                Date zgotoTime = null;
                try {
                    zgotoTime = hms.parse(timeReq.getGotoTime());
                }
                catch (Exception e) {
                    throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0a\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                }
                Date zgooffTime = null;
                try {
                    zgooffTime = hms.parse(timeReq.getGooffTime());
                }
                catch (Exception e) {
                    throw new BusinessException("\u6253\u5361\u65f6\u95f4\uff0c\u4e0b\u73ed\u6253\u5361\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
                }
                if ((zgotoTime.getTime() > gotoTime.getTime() || gotoTime.getTime() > zgooffTime.getTime()) && (zgotoTime.getTime() > gooffTime.getTime() || gooffTime.getTime() > zgooffTime.getTime())) continue;
                throw new BusinessException("\u7b2c" + t + "\u884c\u6253\u5361\u65f6\u95f4,\u4e0e\u7b2c" + i + "\u884c\u6253\u5361\u65f6\u95f4,\u4e0a\u73ed\u65f6\u95f4\u91cd\u590d");
            }
            ++t;
        }
        AssertUtils.isNotEmpty((String)reqVo.getWorkingDay(), (String)"\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
        if (StringUtils.isEmpty((CharSequence)reqVo.getHolidayWhether()) || !SfaWorkSignEnum.isHolidayWhether.equals(reqVo.getHolidayWhether())) {
            reqVo.setHolidayWhether(null);
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getWsrPhotograph()) || !SfaWorkSignEnum.isWsrPhotograph.equals(reqVo.getWsrPhotograph())) {
            reqVo.setWsrPhotograph(null);
        }
        AssertUtils.isNotEmpty((String)reqVo.getGooffWork(), (String)"\u8bf7\u9009\u62e9\u4e0b\u73ed\u6253\u5361\u9650\u5236");
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(SfaWorkSignRuleReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleEntity::getRuleName, (Object)reqVo.getRuleName());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.sfaWorkSignRuleMapper.selectOne((Wrapper)wrapper));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u8003\u52e4\u89c4\u5219\u6570\u636e\u540d\u79f0\u91cd\u590d,\u8bf7\u68c0\u67e5");
    }
}

