/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.notice.mapper.SfaNoticeReadMapper;
import com.biz.crm.notice.model.SfaNoticeReadEntity;
import com.biz.crm.notice.service.ISfaNoticeReadService;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaNoticeReadServiceExpandImpl"})
public class SfaNoticeReadServiceImpl
extends ServiceImpl<SfaNoticeReadMapper, SfaNoticeReadEntity>
implements ISfaNoticeReadService {
    private static final Logger log = LoggerFactory.getLogger(SfaNoticeReadServiceImpl.class);
    @Resource
    private SfaNoticeReadMapper sfaNoticeReadMapper;

    @Override
    @CrmLog
    public PageResult<SfaNoticeReadRespVo> findList(SfaNoticeReadReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaNoticeReadRespVo> list = this.sfaNoticeReadMapper.findList((Page<SfaNoticeReadRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaNoticeReadRespVo query(SfaNoticeReadReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaNoticeReadReqVo reqVo) {
        SfaNoticeReadEntity entity = (SfaNoticeReadEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaNoticeReadEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaNoticeReadReqVo reqVo) {
        SfaNoticeReadEntity entity = (SfaNoticeReadEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaNoticeReadReqVo reqVo) {
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaNoticeReadReqVo reqVo) {
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaNoticeReadReqVo reqVo) {
        List sfaNoticeReadEntities = this.sfaNoticeReadMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaNoticeReadEntities)) {
            sfaNoticeReadEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }
}

