/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitPlanInfoServiceExpandImpl"})
public class SfaVisitPlanInfoServiceImpl
extends ServiceImpl<SfaVisitPlanInfoMapper, SfaVisitPlanInfoEntity>
implements ISfaVisitPlanInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;

    @Override
    public PageResult<SfaVisitPlanInfoRespVo> findList(SfaVisitPlanInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanInfoRespVo> list = this.sfaVisitPlanInfoMapper.findList((Page<SfaVisitPlanInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitProgressRespVo visitProgress(SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        SfaVisitProgressRespVo sfaVisitProgressRespVo = new SfaVisitProgressRespVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"visit_user_name", (Object)sfaVisitPlanInfoReqVo.getVisitUserName());
        queryWrapper.eq((Object)"visit_status", (Object)SfaVisitStatusEnum.PROCESSING.getCode());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (sfaVisitPlanInfoEntity != null) {
            sfaVisitProgressRespVo.setInProgress(Boolean.valueOf(true));
            sfaVisitProgressRespVo.setClientId(sfaVisitPlanInfoEntity.getClientId());
            sfaVisitProgressRespVo.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
            sfaVisitProgressRespVo.setClientName(sfaVisitPlanInfoEntity.getClientName());
            sfaVisitProgressRespVo.setClientType(sfaVisitPlanInfoEntity.getClientType());
        }
        sfaVisitPlanInfoReqVo.setVisitStatus(SfaVisitStatusEnum.FINISHED.getCode());
        int rows = this.sfaVisitPlanInfoMapper.getCount(sfaVisitPlanInfoReqVo);
        sfaVisitProgressRespVo.setComplete(Integer.valueOf(rows));
        return sfaVisitProgressRespVo;
    }

    @Override
    public SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        return (SfaVisitPlanInfoRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoEntity), SfaVisitPlanInfoRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanInfoEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitPlanInfoReqVo reqVo) {
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitPlanInfoReqVo reqVo) {
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitPlanInfoReqVo reqVo) {
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }
}

