/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRuleInfoMapper;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignRuleInfoServiceExpandImpl"})
public class SfaWorkSignRuleInfoServiceImpl
extends ServiceImpl<SfaWorkSignRuleInfoMapper, SfaWorkSignRuleInfoEntity>
implements ISfaWorkSignRuleInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleInfoServiceImpl.class);
    @Resource
    private SfaWorkSignRuleInfoMapper sfaWorkSignRuleInfoMapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;

    @Override
    public PageResult<SfaWorkSignRuleInfoRespVo> findList(SfaWorkSignRuleInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRuleInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findList((Page<SfaWorkSignRuleInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRuleInfoRespVo query(SfaWorkSignRuleInfoReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleInfoEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(SfaWorkSignInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findWorkSignInfoList((Page<SfaWorkSignInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Result<SfaWorkSignRecordRespVo> fingGotoWorkClockIn() {
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        String username = userRedis.getUsername();
        Date currentTime = new Date();
        String ruleDate = DateUtil.date_sdf.format(currentTime);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)username)).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate);
        wrapper.orderByAsc(SfaWorkSignRuleInfoEntity::getGotoTime);
        List sfaWorkSignRuleInfoList = this.sfaWorkSignRuleInfoMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRuleInfoList)) {
            result.error500("\u4eca\u65e5\u65e0\u7b7e\u5230!");
            return result;
        }
        SfaWorkSignRuleInfoRespVo ruleInfoRespVo = null;
        for (SfaWorkSignRuleInfoEntity ruleInfo : sfaWorkSignRuleInfoList) {
            try {
                Date gooffStartTime = DateUtil.datetimeFormat.parse(ruleDate + " " + ruleInfo.getGooffStartTime());
                Date gooffEndTime = DateUtil.datetimeFormat.parse(ruleDate + " " + ruleInfo.getGooffEndTime());
                if (gooffStartTime.getTime() > currentTime.getTime() || gooffEndTime.getTime() < currentTime.getTime()) continue;
                ruleInfoRespVo = new SfaWorkSignRuleInfoRespVo();
                CrmBeanUtil.copyProperties((Object)((Object)ruleInfo), (Object)ruleInfoRespVo);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null == ruleInfoRespVo) {
            result.error500("\u5f53\u524d\u65f6\u95f4\u672a\u5230\u4e0a\u73ed\u7b7e\u5230\u65f6\u95f4,\u6216\u5df2\u8fc7\u4e0a\u73ed\u7b7e\u5230\u65f6\u95f4!");
            return result;
        }
        LambdaQueryWrapper recordWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)ruleInfoRespVo.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R1.getVal());
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectList((Wrapper)recordWrapper);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRecordEntities)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5\u65e0\u9700\u4e0a\u73ed\u7b7e\u5230!");
            return result;
        }
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)sfaWorkSignRecordEntities.get(0));
        String gooffWork = ruleInfoRespVo.getGooffWork();
        if (SfaWorkSignEnum.gooffWorkEnum.Three.equals((Object)gooffWork)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5\u65e0\u9700\u4e0a\u73ed\u6253\u5361!");
            return result;
        }
        SfaWorkSignRecordRespVo workSignRecordRespVo = new SfaWorkSignRecordRespVo();
        CrmBeanUtil.copyProperties((Object)((Object)sfaWorkSignRecord), (Object)workSignRecordRespVo);
        workSignRecordRespVo.setGotoEndTime(ruleInfoRespVo.getGotoEndTime());
        workSignRecordRespVo.setGooffEndTime(ruleInfoRespVo.getGooffEndTime());
        workSignRecordRespVo.setGooffStartTime(ruleInfoRespVo.getGooffStartTime());
        workSignRecordRespVo.setGotoStartTime(ruleInfoRespVo.getGotoStartTime());
        result = Result.ok((Object)workSignRecordRespVo);
        return result;
    }

    @Override
    public Result<SfaWorkSignRecordRespVo> fingGooffWorkSignOut() {
        LambdaQueryWrapper recordWrapperR1;
        List recordWrapperR1List;
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        String username = userRedis.getUsername();
        Date currentTime = new Date();
        String ruleDate = DateUtil.date_sdf.format(currentTime);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)username)).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate);
        wrapper.orderByAsc(SfaWorkSignRuleInfoEntity::getGotoTime);
        List sfaWorkSignRuleInfoList = this.sfaWorkSignRuleInfoMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRuleInfoList)) {
            result.error500("\u4eca\u65e5\u65e0\u7b7e\u5230!");
            return result;
        }
        SfaWorkSignRuleInfoRespVo ruleInfoRespVo = null;
        for (SfaWorkSignRuleInfoEntity ruleInfo : sfaWorkSignRuleInfoList) {
            try {
                Date gotoStartTime = DateUtil.datetimeFormat.parse(ruleDate + " " + ruleInfo.getGotoStartTime());
                Date gotoEndTime = DateUtil.datetimeFormat.parse(ruleDate + " " + ruleInfo.getGotoEndTime());
                if (gotoStartTime.getTime() > currentTime.getTime() || gotoEndTime.getTime() < currentTime.getTime()) continue;
                ruleInfoRespVo = new SfaWorkSignRuleInfoRespVo();
                CrmBeanUtil.copyProperties((Object)((Object)ruleInfo), (Object)ruleInfoRespVo);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null == ruleInfoRespVo) {
            result.error500("\u5f53\u524d\u65f6\u95f4\u672a\u5230\u4e0b\u73ed\u7b7e\u9000\u65f6\u95f4,\u6216\u5df2\u8fc7\u4e0b\u73ed\u7b7e\u9000\u65f6\u95f4!");
            return result;
        }
        LambdaQueryWrapper recordWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)ruleInfoRespVo.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R2.getVal());
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectList((Wrapper)recordWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaWorkSignRecordEntities)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5\u65e0\u9700\u4e0b\u73ed\u7b7e\u9000!");
            return result;
        }
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)sfaWorkSignRecordEntities.get(0));
        if (!SfaWorkSignEnum.workSignState.S0.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())) {
            result.error500("\u4e0b\u73ed\u4ee5\u7b7e\u9000,\u4e0d\u80fd\u91cd\u590d\u7b7e\u9000!");
            return result;
        }
        String gooffWork = ruleInfoRespVo.getGooffWork();
        if (SfaWorkSignEnum.gooffWorkEnum.One.equals((Object)gooffWork)) {
            result.error500("\u5f53\u524d\u4e0a\u73ed\u65f6\u95f4\u6bb5,\u65e0\u9700\u4e0b\u73ed\u7b7e\u9000!");
            return result;
        }
        if (SfaWorkSignEnum.gooffWorkEnum.Two.equals((Object)gooffWork) && (CollectionUtil.listNotEmptyNotSizeZero((List)(recordWrapperR1List = this.sfaWorkSignRecordMapper.selectList((Wrapper)(recordWrapperR1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)ruleInfoRespVo.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.R1.getVal()))))) || SfaWorkSignEnum.workSignState.S0.getVal().equals(((SfaWorkSignRecordEntity)((Object)recordWrapperR1List.get(0))).getWorkSignStatus()))) {
            result.error500("\u4e0a\u73ed\u672a\u7b7e\u5230,\u4e0d\u80fd\u505a\u4e0b\u73ed\u7b7e\u9000!");
            return result;
        }
        SfaWorkSignRecordRespVo workSignRecordRespVo = new SfaWorkSignRecordRespVo();
        CrmBeanUtil.copyProperties((Object)((Object)sfaWorkSignRecord), (Object)workSignRecordRespVo);
        Result.ok((Object)workSignRecordRespVo);
        return result;
    }
}

