/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksignrule.mapper.SfaWorkSignSpecialMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignSpecialServiceExpandImpl"})
public class SfaWorkSignSpecialServiceImpl
extends ServiceImpl<SfaWorkSignSpecialMapper, SfaWorkSignSpecialEntity>
implements ISfaWorkSignSpecialService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignSpecialServiceImpl.class);
    @Resource
    private SfaWorkSignSpecialMapper sfaWorkSignSpecialMapper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignSpecialRespVo> findList(SfaWorkSignSpecialReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignSpecialRespVo> list = this.sfaWorkSignSpecialMapper.findList((Page<SfaWorkSignSpecialRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public List<SfaWorkSignSpecialRespVo> findNonPageList(SfaWorkSignSpecialReqVo reqVo) {
        List<SfaWorkSignSpecialRespVo> list = this.sfaWorkSignSpecialMapper.findList(reqVo);
        return list;
    }

    @Override
    @CrmLog
    public SfaWorkSignSpecialRespVo query(SfaWorkSignSpecialReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignSpecialRespVo();
        }
        SfaWorkSignSpecialRespVo sfaWorkSignSpecialRespVo = (SfaWorkSignSpecialRespVo)list.get(0);
        return sfaWorkSignSpecialRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignSpecialReqVo reqVo) {
        SfaWorkSignSpecialEntity entity = (SfaWorkSignSpecialEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignSpecialEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignSpecialReqVo reqVo) {
        SfaWorkSignSpecialEntity entity = (SfaWorkSignSpecialEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignSpecialReqVo reqVo) {
        List sfaWorkSignSpecialEntities = this.sfaWorkSignSpecialMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignSpecialEntities)) {
            sfaWorkSignSpecialEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignSpecialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignSpecialReqVo reqVo) {
        List sfaWorkSignSpecialEntities = this.sfaWorkSignSpecialMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignSpecialEntities)) {
            sfaWorkSignSpecialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignSpecialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignSpecialReqVo reqVo) {
        List sfaWorkSignSpecialEntities = this.sfaWorkSignSpecialMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignSpecialEntities)) {
            sfaWorkSignSpecialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignSpecialEntities);
    }
}

