/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInStoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOutStoreReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.service.ISfaVisitStepInoutService;
import com.biz.crm.visitstep.service.ISfaVisitStepStockService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visit"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u65e5\u7a0b\u9875\u9762-\u62dc\u8bbf\u6267\u884c"})
public class SfaVisitController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitController.class);
    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaVisitStepInoutService sfaVisitStepInoutService;
    @Autowired
    private ISfaVisitStepStockService sfaVisitStepStockService;

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u8ba1\u5212\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaVisitPlanInfoRespVo>> list(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u67e5\u770b\u62dc\u8bbf\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        PageResult<SfaVisitPlanInfoRespVo> result = this.sfaVisitPlanInfoService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u65e5\u62dc\u8bbf\u8fdb\u5ea6")
    @PostMapping(value={"/progress"})
    @CrmLog
    public Result<SfaVisitProgressRespVo> visitProgress(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitDate())) {
            sfaVisitPlanInfoReqVo.setVisitDate(DateUtil.formatDate());
        }
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            sfaVisitPlanInfoReqVo.setVisitUserName(userName);
        }
        SfaVisitProgressRespVo sfaVisitProgressRespVo = this.sfaVisitPlanInfoService.visitProgress(sfaVisitPlanInfoReqVo);
        return Result.ok((Object)sfaVisitProgressRespVo);
    }

    @ApiOperation(value="\u8fdb\u5e97")
    @PostMapping(value={"/inStore"})
    @CrmLog
    public Result inStore(@RequestBody @Validated SfaVisitStepInStoreReqVo sfaVisitStepInStoreReqVo) {
        try {
            this.sfaVisitStepInoutService.saveInStore(sfaVisitStepInStoreReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }

    @ApiOperation(value="\u8fdb\u5e97")
    @PostMapping(value={"/outStore"})
    @CrmLog
    public Result outStore(@RequestBody @Validated SfaVisitStepOutStoreReqVo sfaVisitStepOutStoreReqVo) {
        try {
            this.sfaVisitStepInoutService.saveOutStore(sfaVisitStepOutStoreReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }
}

