/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.biz.crm.nebular.mdm.humanarea.EnginePositionRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExecuteSignRuleContext {
    private String signDate;
    private List<SfaWorkSignRuleEntity> rules;
    private Set<String> ruleCodes;
    private Map<String, List<SfaWorkSignSpecialEntity>> specialMapping;
    private Map<String, List<SfaWorkSignTimeEntity>> timeMapping;
    private Map<String, List<SfaWorkSignPlaceEntity>> placeMapping;
    private Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping;
    private Map<String, List<EnginePositionRespVo>> orgPositionMappingCurrentY;
    private Map<String, List<EnginePositionRespVo>> orgPositionMappingCurrentN;
    private List<SfaWorkSignRuleInfoEntity> ruleInfoEntities = Lists.newArrayList();
    private List<SfaWorkSignRecordEntity> recordEntities = Lists.newArrayList();
    private Set<String> users = Sets.newHashSet();

    public ExecuteSignRuleContext(List<SfaWorkSignRuleEntity> rules, String signDate) {
        this.rules = rules;
        this.signDate = signDate;
        this.ruleCodes = rules.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet());
    }

    public void addRuleInfo(SfaWorkSignRuleInfoEntity ruleInfoEntitie) {
        if (null == this.ruleInfoEntities) {
            return;
        }
        this.ruleInfoEntities.add(ruleInfoEntitie);
    }

    public void addRecord(List<SfaWorkSignRecordEntity> recordEntities) {
        if (null == recordEntities) {
            return;
        }
        this.recordEntities.addAll(recordEntities);
    }

    public boolean addUser(String user) {
        if (StringUtils.isBlank((CharSequence)user) || this.users.contains(user)) {
            return false;
        }
        this.users.add(user);
        return true;
    }

    public String getSignDate() {
        return this.signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public List<SfaWorkSignRuleEntity> getRules() {
        return this.rules;
    }

    public void setRules(List<SfaWorkSignRuleEntity> rules) {
        this.rules = rules;
    }

    public Set<String> getRuleCodes() {
        return this.ruleCodes;
    }

    public void setRuleCodes(Set<String> ruleCodes) {
        this.ruleCodes = ruleCodes;
    }

    public Map<String, List<SfaWorkSignSpecialEntity>> getSpecialMapping() {
        return this.specialMapping;
    }

    public void setSpecialMapping(Map<String, List<SfaWorkSignSpecialEntity>> specialMapping) {
        this.specialMapping = specialMapping;
    }

    public Map<String, List<SfaWorkSignTimeEntity>> getTimeMapping() {
        return this.timeMapping;
    }

    public void setTimeMapping(Map<String, List<SfaWorkSignTimeEntity>> timeMapping) {
        this.timeMapping = timeMapping;
    }

    public Map<String, List<SfaWorkSignPlaceEntity>> getPlaceMapping() {
        return this.placeMapping;
    }

    public void setPlaceMapping(Map<String, List<SfaWorkSignPlaceEntity>> placeMapping) {
        this.placeMapping = placeMapping;
    }

    public Map<String, List<SfaWorkSignPersonnelEntity>> getPersonnelMapping() {
        return this.personnelMapping;
    }

    public void setPersonnelMapping(Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping) {
        this.personnelMapping = personnelMapping;
    }

    public Map<String, List<EnginePositionRespVo>> getOrgPositionMappingCurrentY() {
        return this.orgPositionMappingCurrentY;
    }

    public void setOrgPositionMappingCurrentY(Map<String, List<EnginePositionRespVo>> orgPositionMappingCurrentY) {
        this.orgPositionMappingCurrentY = orgPositionMappingCurrentY;
    }

    public Map<String, List<EnginePositionRespVo>> getOrgPositionMappingCurrentN() {
        return this.orgPositionMappingCurrentN;
    }

    public void setOrgPositionMappingCurrentN(Map<String, List<EnginePositionRespVo>> orgPositionMappingCurrentN) {
        this.orgPositionMappingCurrentN = orgPositionMappingCurrentN;
    }

    public List<SfaWorkSignRuleInfoEntity> getRuleInfoEntities() {
        return this.ruleInfoEntities;
    }

    public List<SfaWorkSignRecordEntity> getRecordEntities() {
        return this.recordEntities;
    }

    public Set<String> getUsers() {
        return this.users;
    }
}

