/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkTaskReceveServiceExpandImpl"})
public class SfaWorkTaskReceveServiceImpl
extends ServiceImpl<SfaWorkTaskReceveMapper, SfaWorkTaskReceveEntity>
implements ISfaWorkTaskReceveService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkTaskReceveServiceImpl.class);
    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;

    @Override
    public PageResult<SfaWorkTaskReceveRespVo> findList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();
        reqVo.setReceverName(username);
        reqVo.setExecuteStatus(SfaTaskStatusEnum.getType(reqVo.getExecuteStatus()));
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReceveRespVo> list = this.sfaWorkTaskReceveMapper.findList((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaWorkTaskReceveRespVo> findDayList(SfaWorkTaskReceveReqVo reqVo) throws Exception {
        UserRedis user = UserUtils.getUser();
        String username = user.getUsername();
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReceveRespVo> list = this.sfaWorkTaskReceveMapper.findList((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        List<SfaWorkTaskReceveRespVo> offTheStocks = this.sfaWorkTaskReceveMapper.findOffTheStocks(reqVo);
        ArrayList<SfaWorkTaskReceveRespVo> receveRespVos = new ArrayList<SfaWorkTaskReceveRespVo>();
        for (SfaWorkTaskReceveRespVo next : list) {
            if (!username.equals(next.getTaskInPerson())) {
                next.setId("");
            }
            receveRespVos.add(next);
        }
        for (SfaWorkTaskReceveRespVo next : offTheStocks) {
            receveRespVos.add(next);
        }
        return receveRespVos;
    }

    @Override
    public SfaWorkTaskReceveRespVo query(String receveId) {
        SfaWorkTaskReceveRespVo one = this.sfaWorkTaskReceveMapper.findOne(receveId);
        List<SfaWorkTaskPictureRespVo> pictures = this.sfaWorkTaskPictureMapper.findOneByTaskId(one.getTaskId());
        one.setPictures(pictures);
        return one;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkTaskReceveReqVo reqVo) {
        SfaWorkTaskReceveEntity entity = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReceveEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkTaskReceveReqVo reqVo) {
        SfaWorkTaskReceveEntity entity = (SfaWorkTaskReceveEntity)((Object)this.getById((Serializable)((Object)reqVo.getReceveId())));
        entity.setAddress(reqVo.getAddress());
        entity.setSummary(reqVo.getSummary());
        entity.setExecuteStatus(reqVo.getExecuteStatus());
        this.updateById((Object)entity);
    }
}

