/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReleaseMapper;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskReleaseEnum;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.nebular.sfa.assistant.req.SfaStaffMessageReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskPictureReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkTaskReleaseServiceExpandImpl"})
public class SfaWorkTaskReleaseServiceImpl
extends ServiceImpl<SfaWorkTaskReleaseMapper, SfaWorkTaskReleaseEntity>
implements ISfaWorkTaskReleaseService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkTaskReleaseServiceImpl.class);
    @Resource
    private SfaWorkTaskReleaseMapper sfaWorkTaskReleaseMapper;
    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;

    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findList(SfaWorkTaskReleaseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReleaseRespVo> list = this.sfaWorkTaskReleaseMapper.findList((Page<SfaWorkTaskReleaseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findListAll(SfaWorkTaskReleaseReqVo reqVo) {
        String name = UserUtils.getUser().getUsername();
        reqVo.setCreateCode(name);
        reqVo.setTaskStatus(SfaTaskReleaseEnum.getType(reqVo.getTaskStatus()));
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReleaseRespVo> list = this.sfaWorkTaskReleaseMapper.findListAll((Page<SfaWorkTaskReleaseRespVo>)page, reqVo);
        for (SfaWorkTaskReleaseRespVo next : list) {
            int num = 0;
            List<SfaWorkTaskReceveRespVo> byTaskId = this.sfaWorkTaskReceveMapper.findListByTaskId(next.getTaskId());
            int size = byTaskId.size();
            if (size == 1) {
                next.setExecutor(byTaskId.iterator().next().getTaskInPerson());
                continue;
            }
            for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : byTaskId) {
                if (!SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus())) continue;
                ++num;
            }
            next.setQuantityNum(String.valueOf(num));
            next.setSumAll(String.valueOf(size));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkTaskReleaseRespVo query(SfaWorkTaskReleaseReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkTaskReleaseReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        SfaWorkTaskReleaseEntity entity = (SfaWorkTaskReleaseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReleaseEntity.class));
        entity.setTaskStatus(SfaTaskReleaseEnum.WAIT_EXECUTE.getCode());
        entity.setProgress("0");
        this.sfaWorkTaskReleaseMapper.insert((Object)entity);
        String id = entity.getId();
        List reqVos = reqVo.getSfaStaffMessageReqVos();
        for (SfaStaffMessageReqVo next : reqVos) {
            SfaWorkTaskReceveEntity entityReceve = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)next, SfaWorkTaskReceveEntity.class));
            entityReceve.setReceveDate(new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(new Date()));
            entityReceve.setExecuteStatus(SfaTaskStatusEnum.WAIT_EXECUTE.getCode());
            entityReceve.setTaskId(id);
            this.sfaWorkTaskReceveMapper.insert((Object)entityReceve);
        }
        List pictures = reqVo.getPictures();
        if (pictures != null) {
            for (SfaWorkTaskPictureReqVo next : pictures) {
                SfaWorkTaskPictureEntity taskPictureEntity = (SfaWorkTaskPictureEntity)((Object)CrmBeanUtil.copy((Object)next, SfaWorkTaskPictureEntity.class));
                taskPictureEntity.setTaskId(id);
                this.sfaWorkTaskPictureMapper.insert((Object)taskPictureEntity);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkTaskReleaseReqVo reqVo) {
        SfaWorkTaskReceveEntity entityReceve = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReceveEntity.class));
        int i = this.sfaWorkTaskReceveMapper.updateById((Object)entityReceve);
    }
}

