/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkSummaryCrewMapper;
import com.biz.crm.assistant.mapper.SfaWorkSummaryMapper;
import com.biz.crm.assistant.model.SfaWorkSummaryCrewEntity;
import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.assistant.service.ISfaWorkSummaryCrewService;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaStaffMessageReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSummaryServiceExpandImpl"})
public class SfaWorkSummaryServiceImpl
extends ServiceImpl<SfaWorkSummaryMapper, SfaWorkSummaryEntity>
implements ISfaWorkSummaryService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryServiceImpl.class);
    @Resource
    private SfaWorkSummaryMapper sfaWorkSummaryMapper;
    @Resource
    private SfaWorkSummaryCrewMapper sfaWorkSummaryCrewMapper;
    @Resource
    private ISfaWorkSummaryCrewService sfaWorkSummaryCrewService;
    @Resource
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaWorkSummaryRespVo> findList(SfaWorkSummaryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        String visibility = reqVo.getVisibility();
        MdmPositionUserOrgReqVo mpuor = new MdmPositionUserOrgReqVo();
        mpuor.setOrgCode(user.getOrgcode());
        mpuor.setPositionCode(user.getPoscode());
        List orgList = (List)this.mdmPositionFeign.findPositionUserOrgList(mpuor).getResult();
        ArrayList<String> list1 = new ArrayList<String>();
        for (Object mdmPositionUserOrgRespVo : orgList) {
            list1.add(mdmPositionUserOrgRespVo.getParentCode());
        }
        reqVo.setSupPosition(list1);
        reqVo.setPresentOrgCode(user.getOrgcode());
        mpuor.setParentCode(user.getPoscode());
        List orgLowerList = (List)this.mdmPositionFeign.findPositionUserOrgList(mpuor).getResult();
        list1 = new ArrayList();
        for (MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo : orgList) {
            list1.add(mdmPositionUserOrgRespVo.getParentCode());
        }
        reqVo.setSubPosition(list1);
        List<SfaWorkSummaryRespVo> list = this.sfaWorkSummaryMapper.findList((Page<SfaWorkSummaryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo reqVo) {
        return this.sfaWorkSummaryMapper.findOneById(reqVo.getId());
    }

    @Override
    public void save(SfaWorkSummaryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryEntity.class));
        if (StringUtils.isEmpty((String)reqVo.getVisibility())) {
            reqVo.setVisibility("1");
        }
        this.sfaWorkSummaryMapper.insert((Object)entity);
        String visibility = reqVo.getVisibility();
        ArrayList<SfaWorkSummaryCrewEntity> entities = new ArrayList<SfaWorkSummaryCrewEntity>();
        if ("3".equals(visibility)) {
            List vos = reqVo.getSfaStaffMessageReqVos();
            for (SfaStaffMessageReqVo next : vos) {
                SfaWorkSummaryCrewEntity copy = new SfaWorkSummaryCrewEntity();
                copy.setSummaryId(entity.getId());
                copy.setPersonCode(next.getReceverCode());
                entities.add(copy);
            }
        }
        List partition = Lists.partition(entities, (int)50);
        for (List sfaWorkSummaryCrewEntities : partition) {
            this.sfaWorkSummaryCrewService.saveBatch(sfaWorkSummaryCrewEntities);
        }
    }

    @Override
    public void update(SfaWorkSummaryReqVo reqVo) {
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }
}

