/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRuleInfoMapper;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRuleInfoServiceExpandImpl"})
public class SfaWorkSignRuleInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRuleInfoMapper, SfaWorkSignRuleInfoEntity>
implements ISfaWorkSignRuleInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleInfoServiceImpl.class);
    @Resource
    private SfaWorkSignRuleInfoMapper sfaWorkSignRuleInfoMapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;

    @Override
    public PageResult<SfaWorkSignRuleInfoRespVo> findList(SfaWorkSignRuleInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRuleInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findList((Page<SfaWorkSignRuleInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRuleInfoRespVo query(SfaWorkSignRuleInfoReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleInfoEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(SfaWorkSignInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findWorkSignInfoList((Page<SfaWorkSignInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Result<SfaWorkSignRecordRespVo> fingGotoWorkClockIn() {
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock(true);
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)this.sfaWorkSignRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfoEntity.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal())));
        if (null == sfaWorkSignRecord) {
            throw new BusinessException("\u4eca\u65e5\u65e0\u9700\u7b7e\u5230");
        }
        if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())) {
            workSignRuleInfoEntity.checkSignTime(true);
        }
        SfaWorkSignRecordRespVo workSignRecordRespVo = (SfaWorkSignRecordRespVo)CrmBeanUtil.copy((Object)((Object)sfaWorkSignRecord), SfaWorkSignRecordRespVo.class);
        workSignRecordRespVo.setGotoEndTime(workSignRuleInfoEntity.getGotoEndTime());
        workSignRecordRespVo.setGooffEndTime(workSignRuleInfoEntity.getGooffEndTime());
        workSignRecordRespVo.setGooffStartTime(workSignRuleInfoEntity.getGooffStartTime());
        workSignRecordRespVo.setGotoStartTime(workSignRuleInfoEntity.getGotoStartTime());
        workSignRecordRespVo.setGotoTime(workSignRuleInfoEntity.getGotoTime());
        workSignRecordRespVo.setGooffTime(workSignRuleInfoEntity.getGooffTime());
        workSignRecordRespVo.setRuleDate(workSignRuleInfoEntity.getRuleDate());
        workSignRecordRespVo.setSfaWorkSignPictureRespVos(this.sfaWorkSignPictureService.selectByRecordId(sfaWorkSignRecord.getId()));
        return Result.ok((Object)workSignRecordRespVo);
    }

    @Override
    public SfaWorkSignRuleInfoEntity loadRuleInfoForClock(boolean isClockIn) {
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            throw new BusinessException("\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        String username = userRedis.getUsername();
        String ruleDate = LocalDateTime.now().format(CrmDateUtils.yyyyMMdd);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)username)).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate);
        wrapper.orderByAsc(SfaWorkSignRuleInfoEntity::getGotoTime);
        SfaWorkSignRuleInfoEntity sfaWorkSignRuleInfo = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoMapper.selectOne((Wrapper)wrapper));
        if (null == sfaWorkSignRuleInfo) {
            throw new BusinessException("\u4eca\u65e5\u65e0\u9700\u7b7e\u5230");
        }
        return sfaWorkSignRuleInfo;
    }

    @Override
    public Result<SfaWorkSignRecordRespVo> fingGooffWorkSignOut() {
        String end;
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock(false);
        Map<String, SfaWorkSignRecordEntity> sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfoEntity.getId())).stream().collect(Collectors.toMap(SfaWorkSignRecordEntity::getWorkSignType, v -> v, (t, t2) -> t2));
        SfaWorkSignRecordEntity clockOut = sfaWorkSignRecordEntities.get(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
        if (null == clockOut) {
            throw new BusinessException("\u4eca\u65e5\u65e0\u9700\u6253\u5361");
        }
        if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockOut.getWorkSignStatus())) {
            workSignRuleInfoEntity.checkSignTime(false);
        }
        SfaWorkSignRecordEntity clockIn = sfaWorkSignRecordEntities.get(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
        String string = end = StringUtils.isBlank((CharSequence)workSignRuleInfoEntity.getGotoEndTime()) ? "12:00:00" : workSignRuleInfoEntity.getGotoEndTime();
        if (SfaWorkSignEnum.GooffWorkSignAstrictEnum.GOTO_WORK_REQUIRED.getVal().equals(workSignRuleInfoEntity.getGooffWorkSignAstrict()) && LocalTime.now().compareTo(LocalTime.parse(end, CrmDateUtils.HHmmss)) < 0 && (null == clockIn || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockIn.getWorkSignStatus()))) {
            throw new BusinessException("\u672a\u4e0a\u73ed\u6253\u5361\uff0c\u4e0d\u80fd\u4e0b\u73ed\u6253\u5361\uff01");
        }
        SfaWorkSignRecordRespVo workSignRecordRespVo = (SfaWorkSignRecordRespVo)CrmBeanUtil.copy((Object)((Object)clockOut), SfaWorkSignRecordRespVo.class);
        workSignRecordRespVo.setGotoEndTime(workSignRuleInfoEntity.getGotoEndTime());
        workSignRecordRespVo.setGooffEndTime(workSignRuleInfoEntity.getGooffEndTime());
        workSignRecordRespVo.setGooffStartTime(workSignRuleInfoEntity.getGooffStartTime());
        workSignRecordRespVo.setGotoStartTime(workSignRuleInfoEntity.getGotoStartTime());
        workSignRecordRespVo.setRuleDate(workSignRuleInfoEntity.getRuleDate());
        workSignRecordRespVo.setSfaWorkSignPictureRespVos(this.sfaWorkSignPictureService.selectByRecordId(clockOut.getId()));
        return Result.ok((Object)workSignRecordRespVo);
    }

    @Override
    public void saveBatchPartition(List<SfaWorkSignRuleInfoEntity> infoEntityList) {
        if (CollectionUtil.listEmpty(infoEntityList)) {
            return;
        }
        List partitionList = Lists.partition(infoEntityList, (int)50);
        for (List infoEntities : partitionList) {
            this.saveBatch(infoEntities);
        }
    }
}

