/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.calculateSalaryDate.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.calculateSalaryDate.mapper.SfaCalculateSalaryDateMapper;
import com.biz.crm.calculateSalaryDate.model.SfaCalculateSalaryDateEntity;
import com.biz.crm.calculateSalaryDate.model.SfaCalculateSalaryDateLogEntity;
import com.biz.crm.calculateSalaryDate.service.ISfaCalculateSalaryDateLogService;
import com.biz.crm.calculateSalaryDate.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.calculateSalaryDate.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalaryDate.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCalculateSalaryDateServiceExpandImpl"})
@Transactional
public class SfaCalculateSalaryDateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCalculateSalaryDateMapper, SfaCalculateSalaryDateEntity>
implements ISfaCalculateSalaryDateService {
    private static final Logger log = LoggerFactory.getLogger(SfaCalculateSalaryDateServiceImpl.class);
    @Resource
    private SfaCalculateSalaryDateMapper sfaCalculateSalaryDateMapper;
    @Autowired
    private ISfaCalculateSalaryDateLogService sfaCalculateSalaryDateLogService;

    @Override
    public PageResult<SfaCalculateSalaryDateRespVo> findList(SfaCalculateSalaryDateReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCalculateSalaryDateRespVo> list = this.sfaCalculateSalaryDateMapper.findList((Page<SfaCalculateSalaryDateRespVo>)page, reqVo);
        list.forEach(data -> {
            List<SfaCalculateSalaryDateRespVo> dateRespVoList = this.sfaCalculateSalaryDateMapper.findDateListByYear(data.getYear());
            StringBuffer dateBuffer = new StringBuffer();
            Integer i = 0;
            for (SfaCalculateSalaryDateRespVo dateRespVo : dateRespVoList) {
                if (dateBuffer.length() > 0) {
                    dateBuffer.append(",");
                }
                if (i >= 3) {
                    dateBuffer.append("....");
                    break;
                }
                dateBuffer.append(dateRespVo.getDate());
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            data.setDateList(dateBuffer.toString());
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaCalculateSalaryDateRespVo query(SfaCalculateSalaryDateReqVo reqVo) {
        if (!StringUtils.isNotEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaCalculateSalaryDateEntity dateEntity = (SfaCalculateSalaryDateEntity)((Object)this.sfaCalculateSalaryDateMapper.selectById((Serializable)((Object)reqVo.getId())));
        final SfaCalculateSalaryDateRespVo dateRespVo = (SfaCalculateSalaryDateRespVo)CrmBeanUtil.copy((Object)((Object)dateEntity), SfaCalculateSalaryDateRespVo.class);
        SfaCalculateSalaryDateReqVo dateReqVo = new SfaCalculateSalaryDateReqVo(){
            {
                this.setYear(dateRespVo.getYear());
            }
        };
        List dateRespVoList = this.findList(dateReqVo).getData();
        dateRespVo.setDateRespVoList(dateRespVoList);
        return dateRespVo;
    }

    @Override
    public void importSfaCalculateSalaryDateLogList(List<SfaCalculateSalaryDateReqVo> reqVoList) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(reqVoList)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        List yearList = reqVoList.stream().map(SfaCalculateSalaryDateReqVo::getYear).collect(Collectors.toList());
        if (yearList.size() > 1) {
            throw new BusinessException("\u4e00\u6b21\u5bfc\u5165\u53ea\u80fd\u5b58\u5728\u540c\u4e00\u5e74\u7684\u6570\u636e");
        }
        UserRedis userRedis = UserUtils.getUser();
        ArrayList sfaCalculateSalaryDateEntityList = new ArrayList();
        reqVoList.stream().forEach(data -> {
            try {
                data.setDate(LocalDate.parse(data.getDate(), CrmDateUtils.yyyyMMdd).format(CrmDateUtils.yyyyMMdd));
                data.setUserName(userRedis.getUsername());
                data.setRealName(userRedis.getRealname());
                data.setPosCode(userRedis.getPoscode());
                data.setPosName(userRedis.getPosname());
                data.setOrgCode(userRedis.getOrgcode());
                data.setOrgName(userRedis.getOrgname());
                data.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                data.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaCalculateSalaryDateEntity.class)));
                sfaCalculateSalaryDateEntityList.add(entity);
            }
            catch (Exception e) {
                throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9");
            }
        });
        this.saveBatch(sfaCalculateSalaryDateEntityList);
        sfaCalculateSalaryDateEntityList.stream().forEach(data -> {
            SfaCalculateSalaryDateLogEntity dateLogEntity = (SfaCalculateSalaryDateLogEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaCalculateSalaryDateLogEntity.class)));
            dateLogEntity.setOperationType(CrmDelFlagEnum.NORMAL.getCode());
            dateLogEntity.setId(null);
            this.sfaCalculateSalaryDateLogService.save((Object)dateLogEntity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaCalculateSalaryDateReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCalculateSalaryDateEntity.class));
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setOrgName(userRedis.getOrgname());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        SfaCalculateSalaryDateLogEntity dateLogEntity = (SfaCalculateSalaryDateLogEntity)((Object)CrmBeanUtil.copy((Object)((Object)entity), SfaCalculateSalaryDateLogEntity.class));
        dateLogEntity.setOperationType(CrmDelFlagEnum.NORMAL.getCode());
        dateLogEntity.setId(null);
        this.sfaCalculateSalaryDateLogService.save((Object)dateLogEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaCalculateSalaryDateReqVo reqVo) {
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaCalculateSalaryDateReqVo reqVo = new SfaCalculateSalaryDateReqVo(){
            {
                this.setIds(ids);
            }
        };
        List dateRespVoList = this.findList(reqVo).getData();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)dateRespVoList)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        UserRedis userRedis = UserUtils.getUser();
        dateRespVoList.forEach(data -> {
            SfaCalculateSalaryDateLogEntity dateLogEntity = (SfaCalculateSalaryDateLogEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaCalculateSalaryDateLogEntity.class)));
            dateLogEntity.setOperationType(CrmDelFlagEnum.DELETE.getCode());
            dateLogEntity.setId(null);
            dateLogEntity.setOrgCode(userRedis.getOrgcode());
            dateLogEntity.setOrgName(userRedis.getOrgname());
            dateLogEntity.setPosCode(userRedis.getPoscode());
            dateLogEntity.setPosName(userRedis.getPosname());
            dateLogEntity.setUserName(userRedis.getUsername());
            dateLogEntity.setRealName(userRedis.getRealname());
            this.sfaCalculateSalaryDateLogService.save((Object)dateLogEntity);
        });
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }
}

